% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_groups.R
\name{interval_groups}
\alias{interval_groups}
\title{Split Continuous Variable into Equal-Width Groups}
\usage{
interval_groups(x, groups = 5, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{groups}{Numeric value indicating how many groups should be created.}

\item{...}{Further arguments to pass to \code{\link[base]{cut}}.}
}
\value{
Factor variable.
}
\description{
Splits a continuous variable into equal-width groups. Useful for assessing
linearity in regression models.
}
\examples{
# Convert values from N(0, 1) into 6 equal-width groups
x <- rnorm(1000)
groups <- interval_groups(x, 6)
table(groups)

# Use interval_groups to detect non-linearity
set.seed(123)
x <- rnorm(1000)
y <- 1.5 + 1.25 * x + 0.25 * x^2 + rnorm(1000)
plot(tapply(y, interval_groups(x), mean))

}
\seealso{
\code{\link[base]{cut}}
}
