% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_duke_fill_discrete.R
\name{scale_duke_fill_discrete}
\alias{scale_duke_fill_discrete}
\title{Discrete scale constructor for fill argument.}
\usage{
scale_duke_fill_discrete(..., na.value = "#B5B5B5")
}
\arguments{
\item{...}{Arguments passed on to \code{discrete_scale}.}

\item{na.value}{Color used for NA values}
}
\value{
a visualization with discrete duke color scale in fill
}
\description{
Applies a Duke branded and accessible discrete color palette to ggplot
geometric objects using fill argument. It prioritizes high contrast colors
aligned with Web Content Accessibility Guidelines (WCAG).
}
\examples{
library(ggplot2)
library(dplyr)
library(palmerpenguins)

# default
ggplot(penguins, aes(x = species, fill = species)) +
  geom_bar()

# vs. with Duke scale
ggplot(penguins, aes(x = species, fill = species)) +
  geom_bar() +
  scale_duke_fill_discrete()

# Make some species NAs to demonstrate na.value usage
penguins_with_NAs <- penguins |>
  mutate(species = if_else(species == "Gentoo", NA, species))

# with default na.value
ggplot(penguins_with_NAs, aes(x = species, fill = species)) +
  geom_bar() +
  scale_duke_fill_discrete()

# with custom na.value
ggplot(penguins_with_NAs, aes(x = species, fill = species)) +
  geom_bar() +
  scale_duke_fill_discrete(na.value = "pink")
}
