% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_read.R
\name{ddbs_read_vector}
\alias{ddbs_read_vector}
\title{Load vectorial data from DuckDB into R}
\usage{
ddbs_read_vector(
  conn,
  name,
  crs = NULL,
  crs_column = "crs_duckspatial",
  clauses = NULL
)
}
\arguments{
\item{conn}{a connection object to a DuckDB database}

\item{name}{a character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table names.}

\item{crs}{the coordinates reference system of the data. Specify if the data
doesn't have crs_column, and you know the crs}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}). Set
to NULL if absent}

\item{clauses}{character, additional SQL code to modify the query from the
table (e.g. "WHERE ...", "ORDER BY...")}
}
\value{
an sf object
}
\description{
Retrieves the data from a DuckDB table with a geometry column, and convert
it to an R \code{sf} object.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## load packages
library(duckdb)
library(duckspatial)
library(sf)

## connect to in memory database
conn <- dbConnect(duckdb::duckdb())

## install the spatial exntesion
ddbs_install(conn)
ddbs_load(conn)

## create random points
random_points <- data.frame(
  id = 1:5,
  x = runif(5, min = -180, max = 180),
  y = runif(5, min = -90, max = 90)
)

## convert to sf
sf_points <- st_as_sf(random_points, coords = c("x", "y"), crs = 4326)

## insert data into the database
ddbs_write_vector(conn, sf_points, "points")

## read data back into R
ddbs_read_vector(conn, "points", crs = 4326)

## disconnect from db
dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
