//===----------------------------------------------------------------------===//
//                         DuckDB
//
// core_functions/scalar/array_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct ArrayValueFun {
	static constexpr const char *Name = "array_value";
	static constexpr const char *Parameters = "any,...";
	static constexpr const char *Description = "Create an ARRAY containing the argument values.";
	static constexpr const char *Example = "array_value(4, 5, 6)";
	static constexpr const char *Categories = "";

	static ScalarFunction GetFunction();
};

struct ArrayCrossProductFun {
	static constexpr const char *Name = "array_cross_product";
	static constexpr const char *Parameters = "array, array";
	static constexpr const char *Description = "Compute the cross product of two arrays of size 3. The array elements can not be NULL.";
	static constexpr const char *Example = "array_cross_product([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayCosineSimilarityFun {
	static constexpr const char *Name = "array_cosine_similarity";
	static constexpr const char *Parameters = "array1,array2";
	static constexpr const char *Description = "Compute the cosine similarity between two arrays of the same size. The array elements can not be NULL. The arrays can have any size as long as the size is the same for both arguments.";
	static constexpr const char *Example = "array_cosine_similarity([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayCosineDistanceFun {
	static constexpr const char *Name = "array_cosine_distance";
	static constexpr const char *Parameters = "array1,array2";
	static constexpr const char *Description = "Compute the cosine distance between two arrays of the same size. The array elements can not be NULL. The arrays can have any size as long as the size is the same for both arguments.";
	static constexpr const char *Example = "array_cosine_distance([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayDistanceFun {
	static constexpr const char *Name = "array_distance";
	static constexpr const char *Parameters = "array1,array2";
	static constexpr const char *Description = "Compute the distance between two arrays of the same size. The array elements can not be NULL. The arrays can have any size as long as the size is the same for both arguments.";
	static constexpr const char *Example = "array_distance([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayInnerProductFun {
	static constexpr const char *Name = "array_inner_product";
	static constexpr const char *Parameters = "array1,array2";
	static constexpr const char *Description = "Compute the inner product between two arrays of the same size. The array elements can not be NULL. The arrays can have any size as long as the size is the same for both arguments.";
	static constexpr const char *Example = "array_inner_product([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayDotProductFun {
	using ALIAS = ArrayInnerProductFun;

	static constexpr const char *Name = "array_dot_product";
};

struct ArrayNegativeInnerProductFun {
	static constexpr const char *Name = "array_negative_inner_product";
	static constexpr const char *Parameters = "array1,array2";
	static constexpr const char *Description = "Compute the negative inner product between two arrays of the same size. The array elements can not be NULL. The arrays can have any size as long as the size is the same for both arguments.";
	static constexpr const char *Example = "array_negative_inner_product([1, 2, 3], [1, 2, 3])";
	static constexpr const char *Categories = "";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayNegativeDotProductFun {
	using ALIAS = ArrayNegativeInnerProductFun;

	static constexpr const char *Name = "array_negative_dot_product";
};

} // namespace duckdb
