//===----------------------------------------------------------------------===//
//                         DuckDB
//
// duckdb/core_functions/scalar/random_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is generated by scripts/generate_functions.py

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct RandomFun {
	static constexpr const char *Name = "random";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "returns a random number between 0 and 1";
	static constexpr const char *Example = "random()";

	static ScalarFunction GetFunction();
};

struct SetseedFun {
	static constexpr const char *Name = "setseed";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "sets the seed to be used for the random function";
	static constexpr const char *Example = "setseed(0.42)";

	static ScalarFunction GetFunction();
};

struct UUIDFun {
	static constexpr const char *Name = "uuid";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "Return a random uuid similar to this: eeccb8c5-9943-b2bb-bb5e-222f4e14b687";
	static constexpr const char *Example = "uuid()";

	static ScalarFunction GetFunction();
};

struct GenRandomUuidFun {
	using ALIAS = UUIDFun;

	static constexpr const char *Name = "gen_random_uuid";
};

} // namespace duckdb
