% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lb-improved.R
\name{lb_improved}
\alias{lb_improved}
\title{Lemire's improved DTW lower bound}
\usage{
lb_improved(x, y, window.size = NULL, norm = "L1")
}
\arguments{
\item{x}{A time series.}

\item{y}{A time series with the same length as \code{x}.}

\item{window.size}{Window size for envelope calculation. See details.}

\item{norm}{Pointwise distance. Either \code{L1} for Manhattan distance or \code{L2} for Euclidean.}
}
\value{
The improved lower bound for the DTW distance.
}
\description{
This function calculates a lower bound (LB) on the Dynamic Time Warp (DTW) distance between two time
series. It uses a Sakoe-Chiba constraint.
}
\details{
The lower bound is defined for time series of equal length only.

The windowing constraint uses a centered window. The calculations expect a value in \code{window.size}
that represents the distance between the point considered and one of the edges of the window. Therefore,
if, for example, \code{window.size = 10}, the warping for an observation \eqn{x_i} considers the points
between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting in \code{10*2 + 1 = 21} observations falling within
the window.
}
\examples{
# Sample data
data(uciCT)

# Lower bound distance between two series
d.lbi <- lb_improved(CharTraj[[1]], CharTraj[[2]], window.size = 20)

# Corresponding true DTW distance
d.dtw <- dtw(CharTraj[[1]], CharTraj[[2]],
             window.type = "slantedband", window.size = 20)$distance

d.lbi <= d.dtw
}
\references{
Lemire D (2009). ``Faster retrieval with a two-pass dynamic-time-warping lower bound .'' \emph{Pattern Recognition}, \strong{42}(9), pp.
2169 - 2180. ISSN 0031-3203, \url{http://dx.doi.org/10.1016/j.patcog.2008.11.030}, \url{
http://www.sciencedirect.com/science/article/pii/S0031320308004925}.
}

