% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtts.utils.R
\name{align.idx}
\alias{align.idx}
\alias{align.idx,nanotime,nanotime,nanoduration,nanoduration-method}
\alias{align.idx,nanotime,nanotime,missing,missing-method}
\alias{align.idx,nanotime,nanotime,missing,nanoduration-method}
\alias{align.idx,nanotime,nanotime,nanoduration,missing-method}
\alias{align.idx,nanotime,nanotime,nanoperiod,nanoperiod-method}
\alias{align.idx,nanotime,nanotime,missing,nanoperiod-method}
\alias{align.idx,nanotime,nanotime,nanoperiod,missing-method}
\title{Get the index of the alignment of one vector onto another}
\usage{
align.idx(x, y, start, end, ...)

\S4method{align.idx}{nanotime,nanotime,nanoduration,nanoduration}(
  x,
  y,
  start,
  end,
  sopen = FALSE,
  eopen = TRUE,
  bypass_x_check = FALSE,
  bypass_y_check = FALSE
)

\S4method{align.idx}{nanotime,nanotime,missing,missing}(
  x,
  y,
  start,
  end,
  sopen = FALSE,
  eopen = TRUE,
  bypass_x_check = FALSE,
  bypass_y_check = FALSE
)

\S4method{align.idx}{nanotime,nanotime,missing,nanoduration}(
  x,
  y,
  start,
  end,
  sopen = FALSE,
  eopen = TRUE,
  bypass_x_check = FALSE,
  bypass_y_check = FALSE
)

\S4method{align.idx}{nanotime,nanotime,nanoduration,missing}(
  x,
  y,
  start,
  end,
  sopen = FALSE,
  eopen = TRUE,
  bypass_x_check = FALSE,
  bypass_y_check = FALSE
)

\S4method{align.idx}{nanotime,nanotime,nanoperiod,nanoperiod}(
  x,
  y,
  start = as.nanoperiod(0),
  end = as.nanoperiod(0),
  sopen = FALSE,
  eopen = TRUE,
  tz,
  bypass_x_check = FALSE,
  bypass_y_check = FALSE
)

\S4method{align.idx}{nanotime,nanotime,missing,nanoperiod}(
  x,
  y,
  start = as.nanoperiod(0),
  end = as.nanoperiod(0),
  sopen = FALSE,
  eopen = TRUE,
  tz,
  bypass_x_check = FALSE,
  bypass_y_check = FALSE
)

\S4method{align.idx}{nanotime,nanotime,nanoperiod,missing}(
  x,
  y,
  start = as.nanoperiod(0),
  end = as.nanoperiod(0),
  sopen = FALSE,
  eopen = TRUE,
  tz,
  bypass_x_check = FALSE,
  bypass_y_check = FALSE
)
}
\arguments{
\item{x}{the \code{nanotime} vector to align from}

\item{y}{the \code{nanotime} vector to align to}

\item{start}{scalar or vector of same length as \code{y} of type
\code{nanoduration} or \code{nanoperiod}; \code{start} is
added to each element in \code{y} and it then defines the
starting point of the interval under consideration for the
alignment on that element of \code{y}}

\item{end}{scalar or vector of same length as \code{y} of type
\code{nanoduration} or \code{nanoperiod}; \code{start} is
added to each element in \code{y} and it then defines the
ending point of the interval under consideration for the
alignment on that element of \code{y}}

\item{...}{further arguments passed to or from methods.}

\item{sopen}{boolean scalar or vector of same lengths as \code{y}
that indicates if the start of the interval is open or
closed. Defaults to FALSE.}

\item{eopen}{boolean scalar or vector of same lengths as \code{y}
that indicates if the end of the interval is open or
closed. Defaults to TRUE.}

\item{bypass_x_check}{logical indicating if the sorting of
\code{x} should be bypassed. This can provide a marginal
speedup, but should be used carefully.}

\item{bypass_y_check}{logical indicating if the sorting of
\code{y} should be bypassed. This can provide a marginal
speedup, but should be used carefully.}

\item{tz}{scalar or vector of same length as \code{y} of type
character. Only used when the type of \code{start} and
\code{end} is \code{nanoperiod}. It defines the time zone for
the definition of the interval.}
}
\value{
a vector of indices of the same length as \code{y}; this
    vector indexes into \code{x} and represent the closest point
    of \code{x} that is in the interval defined around each point
    in \code{y}
}
\description{
\code{align.idx} returns the index of the alignment of \code{x} on \code{y}
}
\details{
In order to perform the alignment, intervals are created around
each elements in \code{y} using \code{start} and \code{end}. For
each such interval, the closest element in \code{x} is chosen. If
no element in \code{x} falls in the interval, then NaN is
returned.

When only \code{x} and \code{y} are specified, the
    default is to close the intervals so that the alignment simply
    picks up equal points. Note that it is possible to specify
    meaningless intervals, for instance with a \code{start} that
    is beyond \code{end}. In this case, the alignment will simply
    return NA for each element in \code{y}. In principle, the
    \code{start} and \code{end} are chosen to define an interval
    is the past, or around the points in \code{y}, but if they are
    both positive, they can define intervals in the future.
}
\examples{
\dontrun{
align.idx(nanotime(c(10:14, 17:19)), nanotime(11:20))
## [1]  2  3  4  5  NA NA  6  7  8  NA
}
}
