% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvariable.R
\name{dvariable}
\alias{dvariable}
\title{Data.frame of Variables and Classes}
\usage{
dvariable(data1, vars = NULL, as.list = FALSE)
}
\arguments{
\item{data1}{a \code{data.frame}}

\item{vars}{specify one or more variable names with a character vector}

\item{as.list}{logical, \code{TRUE} returns a list split by class}
}
\value{
Returns a data.frame or list with the variable names and their
  respective classes. Returns a data.frame by default.
}
\description{
Helper function for \code{\link{dtable}}. Returns information about each
variable's class, mode, type, and number of response levels in a
\code{data.frame}, or \code{list} if \code{as.list = TRUE}.
}
\examples{
# Describe all variables in iris2
dvariable(iris2)

# Describe one or more specific variables in iris2
dvariable(iris2, vars = "Species")

# Return variable and class data in list
dvariable(iris2, as.list = TRUE)
}
\seealso{
\code{\link{class}} to examine method for extracting class.

\code{\link{mode}} to examine method for extracting mode.

\code{\link{typeof}} to examine method for extracting type.
}

