% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcaRel.R
\name{bcaRel}
\alias{bcaRel}
\title{Representation of a mass function in a product space}
\usage{
bcaRel(tt, spec, infovar, infovarnames = NULL, relnb = NULL)
}
\arguments{
\item{tt}{A (0,1)-matrix or a boolean matrix establishing the relation between two or more variables. The matrix is constructed by placing the variables side by side, as in a truth table representation.}

\item{spec}{A two-column matrix. First column: numbers given to the subsets. Second column: the mass values of the subsets. A subset number and its associated mass value are repeated to match the number of elements of the subset.}

\item{infovar}{A two column matrix containing variable identification numbers and the number of elements of each variable. The identification numbers must be ordered in increasing number.}

\item{infovarnames}{The names of the variables. If omitted, variables are named \code{v1, v2, etc}.}

\item{relnb}{A number given to the relation. Set at 0 if omitted.}
}
\value{
An object of class \code{bcaspec}. This is a list containing the following components:  \itemize{
\item con The measure of conflict.
\item tt The resulting table of subsets. Rownames of the matrix of subsets are generated from the column names of the elements of the product frame. See \code{\link{nameRows}} for details.
\item spec The resulting two-column matrix of specification numbers with associated mass values.
\item infovar The two-column matrix of variables number and size given in the input data.
\item infovaluenames A list of the names of the variables with the name of the elements of their frame of discernment.
\item inforel A two-column matrix containing the relation number and the depth  (number of variables) of the relation.
}
}
\description{
This function is used to represent a mass function which establish a relation between two or more variables in their product space.
}
\examples{
# A logical implication rule
# A typical relation between two variables in the context of expert systems is the
# logical implication \code{(a -> b)}. Let us suppose
# that \code{a} stands for \code{Rain: {yes, no}} and \code{b} stands for
# \code{RoadWorks: {yes, no}}. From experience,
# I am 75 \% sure that there will be RoadWorks if there is no rain.
## 1. The tt table of the logical implication
 ttrwf <- matrix(c(0,1,1,0,1,0,1,0,1,0,0,1,1,1,1,1),
 nrow=4, byrow = TRUE, 
 dimnames = list(NULL, c("rWdy", "rWdn", "Ry", "Rn")) )
 ## The mass distribution
 specrw <-  matrix(c(1,1,1,2,0.75,0.75,0.75,0.25), ncol = 2, 
 dimnames = list(NULL, c("specnb", "mass"))) 
 ## Variables numbers and sizes
 inforw <- matrix(c(4,5,2,2), ncol = 2, 
 dimnames = list(NULL, c("varnb", "size")) )
bcaRel(tt = ttrwf, spec = specrw, infovar = inforw,
 infovarnames = c("RdWorks", "Rain"), relnb = 6)
 
}
\author{
Claude Boivin, Stat.ASSQ
}
