#' Density surface modelling
#'
#' Some blurb will eventually go here.
#'
#'
#' @name dsm-package
#' @import mgcv nlme mrds
#'
NULL


#' Offsets
#'
#' This will be documentation on calculating offsets.
#'
#' @name offsets
#'
NULL


#' Data format for DSM
#'
#' Two \code{data.frame}s must be provided to \code{\link{dsm}}. They are referred to as \code{observation.data} and \code{segment.data} (for observation and segment data, respectively).
#'
#' \code{observation.data} - the observation data frame must have the 
#' following columns:
#' \tabular{ll}{\code{object} \tab unique object identifier \cr
#'    \code{Sample.Label} \tab the identifier for the segment that the 
#'      observation occurred in \cr
#'    \code{size} \tab the size of each observed group (i.e. 1 for 
#'      individuals) \cr
#'    \code{distance} \tab perpendicular/radial distance to observation}
#'
#' \code{segment.data} - the segment data frame must have the following columns:
#'  \tabular{ll}{
#'    \code{Effort} \tab the effort (in terms of length of the segment)\cr
#'    \code{Sample.Label} \tab identifier for the segment (unique!)\cr
#'    \code{???} \tab environmental covariates, for example \code{x} and 
#'          \code{y}}
#'
#' @name dsm-data
NULL

#' Pan-tropical spotted dolphins
#'
#' Data from a combination of several NOAA shipboard surveys conducted on
#' pan-tropical spotted dolphins in the Gulf of Mexico. 47 observations of
#' groups of dolphins The group size was recorded, as well as the Beaufort
#' sea state at the time of the observation. Coordinates for each observation
#' and bathymetry data were also available as covariates for the analysis. A 
#' complete example analysis is provided at \url{https://github.com/dill/dsm/wiki/mexico-analysis}.
#'
#' @references Halpin, P.N., A.J. Read, E. Fujioka, B.D. Best, B. Donnelly, L.J. Hazen, C. Kot, K. Urian, E. LaBrecque, A. Dimatteo, J. Cleary, C. Good, L.B. Crowder, and K.D. Hyrenbach. 2009. OBIS-SEAMAP: The world data center for marine mammal, sea bird, and sea turtle distributions. Oceanography 22(2):104-115
#'
#' NOAA Southeast Fisheries Science Center. 1996. Report of a Cetacean Survey of Oceanic and Selected Continental Shelf Waters of the Northern Gulf of Mexico aboard NOAA Ship Oregon II (Cruise 220)
#'
#' @name mexdolphins
#' @docType data
#' @format List of 5
#' $ obsdata    :'data.frame':  47 obs. of  5 variables:
#'  ..$ object      : int [1:47] 45 61 63 85 114 120 146 165 187 214 ...
#'  ..$ Sample.Label: Factor w/ 387 levels "19960417-1","19960417-2",..: 45 61 63 85 114 120 146 165 187 214 ...
#'  ..$ size        : num [1:47] 21 150 125 75 50 45 40 220 100 35 ...
#'  ..$ distance    : num [1:47] 3297 929 6051 5500 7259 ...
#'  ..$ Effort      : num [1:47] 36300 17800 21000 21800 13400 20900 20600 21700 29400 22900 ...
#' $ preddata   :'data.frame':  1374 obs. of  7 variables:
#'  ..$ latitude : num [1:1374] 30.1 30.1 30.1 30.1 30.1 ...
#'  ..$ longitude: num [1:1374] -87.6 -87.4 -87.2 -87.1 -86.9 ...
#'  ..$ depth    : num [1:1374] 35 30 27 22 46 14 38 58 100 156 ...
#'  ..$ x        : num [1:1374] 70832 86868 102904 118940 134976 ...
#'  ..$ y        : num [1:1374] 341079 341079 341079 341079 341079 ...
#'  ..$ width    : num [1:1374] 32072 32072 32072 32072 32072 ...
#'  ..$ height   : num [1:1374] 37065 37065 37065 37065 37065 ...
#' $ segdata    :'data.frame':  387 obs. of  8 variables:
#'  ..$ latitude      : num [1:387] 29.9 29.8 29.8 29.7 29.6 ...
#'  ..$ longitude     : num [1:387] -86.9 -86.8 -86.7 -86.7 -86.6 ...
#'  ..$ Effort        : num [1:387] 13800 14000 14000 13900 13800 13800 14000 14000 13900 14800 ...
#'  ..$ Transect.Label: Factor w/ 45 levels "19960417","19960418",..: 1 1 1 1 1 1 1 1 1 2 ...
#'  ..$ Sample.Label  : Factor w/ 387 levels "19960417-1","19960417-2",..: 1 2 3 4 5 6 7 8 9 10 ...
#'  ..$ depth         : num [1:387] 135 148 152 164 180 ...
#'  ..$ x             : num [1:387] 134159 143496 152050 161102 169553 ...
#'  ..$ y             : num [1:387] 325561 314055 304324 293475 282984 ...
#' $ distdata   :'data.frame':  47 obs. of  10 variables:
#'  ..$ object   : int [1:47] 45 61 63 85 114 120 146 165 187 214 ...
#'  ..$ size     : num [1:47] 21 150 125 75 50 45 40 220 100 35 ...
#'  ..$ distance : num [1:47] 3297 929 6051 5500 7259 ...
#'  ..$ Effort   : num [1:47] 36300 17800 21000 21800 13400 20900 20600 21700 29400 22900 ...
#'  ..$ detected : num [1:47] 1 1 1 1 1 1 1 1 1 1 ...
#'  ..$ beaufort : num [1:47] 4 4 2 1 3 5 1 5 2 5 ...
#'  ..$ latitude : num [1:47] 27.7 26 26 27.5 27.4 ...
#'  ..$ longitude: num [1:47] -86 -87.6 -87.9 -90.4 -95 ...
#'  ..$ x        : num [1:47] 228139 69199 37046 -210016 -658878 ...
#'  ..$ y        : num [1:47] 79258 -113083 -112197 54208 43337 ...
#' $ survey.area:'data.frame':  45 obs. of  2 variables:
#'  ..$ longitude: num [1:45] -87.4 -94.9 -96.3 -96.5 -96.6 ...
#'  ..$ latitude : num [1:45] 25.8 25.8 25.8 26.2 27.2 ...
#' @keywords datasets
NULL
