% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chainrule.R
\name{chainrule}
\alias{chainrule}
\title{Chainrule}
\usage{
chainrule(f = NULL, g = NULL, deriv = 2, tri = NULL)
}
\arguments{
\item{f}{vector of \eqn{f(\cdot)} evaluated at \eqn{g(\cdot)} with derivatives as attributes.}

\item{g}{matrix of \eqn{g(\cdot)} with derivatives as attributes. Alternatively written as \eqn{g(\cdot)=g_1(x_1),g_2(x_2),...,g_K(x_{K}))}. In this case, \code{g} can be a vector or a list of length \code{k}}

\item{deriv}{derivative of order \code{deriv}. Available are \code{0},\code{2} and \code{4}.}

\item{tri}{optional, index arrays for upper triangular for g, generated by \code{\link[mgcv:trind.generator]{trind.generator()}}.}
}
\value{
A list with partial derivatives. The index of the list corresponds to a matrix with all partial derivatives of that order.
}
\description{
Calculates the partial derivatives of the function \eqn{h(x_1,x_2,...,x_{K})=f(g(x_1,x_2,...,x_{K}))} up to order four. Here \eqn{K} is the number of inputs for function \eqn{g(\cdot)}.
The function \eqn{f(\cdot)} can only have a single input. Alternatively \code{chainrule} can calculate the partial derivatives of \eqn{h(x_1,x_2,...,x_{K})=f(g_1(x_1),g_2(x_2),...,g_K(x_{K}))} up to order four.
Here each \eqn{g_k(\cdot)} can only take a single input \eqn{x_k}. If \eqn{x_i \neq x_j} for \eqn{i,j \in \{1,...,K \}} then the input argument \code{g} can be a list with elements \eqn{g_k(x_k)}.
The function checks the number of inputs of \eqn{f(\cdot)} by counting the number of partial derivatives and then decides automatically how to proceed.
}
\details{
Mostly internal function, which is helpful in calculating the partial derivatives of the loglikelihood.
}
\examples{
x<-1 #For K=1, x_1 value is set to 1.

g<-1/x #g(x_1) = 1/x
attr(g,"gradient")<-matrix(-1/x^2,ncol=1)
attr(g,"hessian")<-matrix(2/x^3,ncol=1)
attr(g,"l3")<-matrix(-6/x^4,ncol=1)
attr(g,"l4")<-matrix(24/x^5,ncol=1)


zeta_g<-zeta(g, deriv=4) #f(g(x)) = zeta(g(x))

chainrule(f=zeta_g, g=g, deriv=4)

}
