\name{genD}
\alias{genD}
\alias{genD.default}
\alias{genD.default.v2}
\alias{genD.c}

\title{Generate Bates and Watts D Matrix}
\description{Generate a matrix of function derivative information.}
\usage{
    genD(obj, ...)
    genD.c(func, x, d=0.01, eps=1e-4, r=6)
    \method{genD}{default}(obj, x, d=0.01, eps=1e-4, r=6, obj.args=NULL)
}
\arguments{
    \item{obj}{
    An function which must have a parameter 
    vector argument as the first argument.}
    \item{x}{The parameter vector first argument to obj.}
    \item{d}{The fraction of x to use for the initial numerical approximation.}
    \item{eps}{Used instead of d for elements of x which are zero.}
    \item{r}{The number of Richardson improvement iterations.}
}
\value{
A list with three elements as follows:
   D is a matrix of first(gradients) and second order partial
      derivatives organized in the same manner as Bates and 
      Watts. (The first p columns are the gradients and the 
      next p(p-1)/2 columns are the lower triangle of the Hessian).
   p is the dimension of the parameter space=dim of the tangent space.
   f0 is the function value at the point where the matrix D 
        was calculated. 
}
\details{The derivatives are calculated numerically using Richardson improvement.}
\seealso{
\code{\link{curvature}}
\code{\link{genD.TSestModel}}
}
\examples{
    func <- function(x){c(x[1], x[1], x[2]^2)}
    z <- genD(func, c(2,2,5))
}
%\keyword{DSE}
\keyword{ts}

