% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPoisDS.R
\name{rPoisDS}
\alias{rPoisDS}
\title{rPoisDS serverside assign function}
\usage{
rPoisDS(n, lambda = 1)
}
\arguments{
\item{n}{length of the pseudorandom number vector to be generated
as specified by the argument <samp.size> in the function ds.rPois}

\item{lambda}{a numeric scalar specifying the expected count of the Poisson
distribution used to generate the random counts. Specified directly
by the lambda argument in ds.rPois. May be a scalar or a vector allowing lambda
to vary from observation to observation.}
}
\value{
Writes the pseudorandom number vector with the characteristics specified
in the function call as a new serverside vector on the data source on which
it has been called. Also returns key information to the clientside:
the random seed as specified by you in each
source + (if requested) the full 626 length random seed vector this generated in
each source (see info for the argument <return.full.seed.as.set>). It
also returns a vector reporting the length of the pseudorandom vector
created in each source.
}
\description{
primary serverside assign function called by ds.rPois
}
\details{
Generates the vector of pseudorandom numbers (non-negative
integers) from a Poisson distribution in each data source as specified
by the arguments of ds.rPois. This serverside
function is effectively the same as the function rpois() in native R
and its arguments are the same.
}
\author{
Paul Burton for DataSHIELD Development Team
}
