% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fun.R
\name{plot_tiles}
\alias{plot_tiles}
\title{Plot n-by-n tiles.}
\usage{
plot_tiles(n = NA, pal = pal_ds4psy, sort = TRUE, borders = TRUE,
  border_col = grey(0, 1), border_size = 0.2, lbl_tiles = FALSE,
  lbl_title = FALSE, polar = FALSE, rseed = NA, save = FALSE,
  save_path = "images/tiles", prefix = "", suffix = "")
}
\arguments{
\item{n}{Basic number of tiles (on either side).}

\item{pal}{A color palette (automatically extended to \code{n x n} colors). 
Default: \code{pal = \link{pal_ds4psy}}.}

\item{sort}{Sort tiles? 
Default: \code{sort = TRUE} (i.e., sorted tiles).}

\item{borders}{Add borders to tiles? 
Default: \code{borders = TRUE} (i.e., use borders).}

\item{border_col}{Color of borders (if \code{borders = TRUE}). 
Default: \code{border_col = grey(0, 1)} (i.e., black).}

\item{border_size}{Size of borders (if \code{borders = TRUE}). 
Default: \code{border_size = 0.2} (i.e., thin).}

\item{lbl_tiles}{Add numeric labels to tiles? 
Default: \code{lbl_tiles = FALSE} (i.e., no labels).}

\item{lbl_title}{Add numeric label (of n) to plot? 
Default: \code{lbl_title = FALSE} (i.e., no title).}

\item{polar}{Plot on polar coordinates? 
Default: \code{polar = FALSE} (i.e., using fixed coordinates).}

\item{rseed}{Random seed (number).
Default: \code{rseed = NA} (using random seed).}

\item{save}{Save plot as png file? 
Default: \code{save = FALSE}.}

\item{save_path}{Path to save plot (if \code{save = TRUE}).
Default: \code{save_path = "images/tiles"}.}

\item{prefix}{Prefix to plot name (if \code{save = TRUE}).
Default: \code{prefix = ""}.}

\item{suffix}{Suffix to plot name (if \code{save = TRUE}).
Default: \code{suffix = ""}.}
}
\description{
\code{plot_tiles} plots an area of \code{n-by-n} tiles 
on fixed or polar coordinates.
}
\examples{
# (1) Tile plot:
plot_tiles()  # default plot (random n, with borders, no labels)

plot_tiles(n =  6, sort = FALSE)      # random order
plot_tiles(n =  8, borders = FALSE)   # no borders
plot_tiles(n = 10, lbl_tiles = TRUE)  # with tile labels 
plot_tiles(n = 10, lbl_title = TRUE)  # with title label 

# Set colors: 
plot_tiles(n = 3, pal = c("steelblue", "white", "black"),
           lbl_tiles = TRUE, sort = TRUE)
plot_tiles(n = 5, pal = c("orange", "white", "firebrick"),
           lbl_tiles = TRUE, lbl_title = TRUE,
           sort = TRUE)
plot_tiles(n = 10, sort = FALSE, border_col = "white", border_size = 2)
  
# Fixed rseed:
plot_tiles(n = 4, sort = FALSE, borders = FALSE, 
           lbl_tiles = TRUE, lbl_title = TRUE, 
           rseed = 101)

# (2) polar plot:  
plot_tiles(polar = TRUE)  # default polar plot (with borders, no labels)

plot_tiles(n =  6, polar = TRUE, sort = FALSE)      # random order
plot_tiles(n =  8, polar = TRUE, borders = FALSE)   # no borders
plot_tiles(n = 10, polar = TRUE, lbl_tiles = TRUE)  # with tile labels 
plot_tiles(n = 10, polar = TRUE, lbl_title = TRUE)  # with title label 

plot_tiles(n = 4, sort = FALSE, borders = TRUE,  
           border_col = "white", border_size = 2, 
           polar = TRUE, rseed = 132)
 
}
\seealso{
\code{\link{pal_ds4psy}} for default color palette.

Other plot functions: \code{\link{plot_fn}},
  \code{\link{plot_fun}}, \code{\link{plot_n}},
  \code{\link{theme_ds4psy}}
}
\concept{plot functions}
