% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_read.R
\name{dr_read}
\alias{dr_read}
\title{Import raw data from water quality instrument}
\usage{
dr_read(file, instrument, defineVar = TRUE, cleanVar = TRUE, case)
}
\arguments{
\item{file}{The name of the file which the data are to be read from. Each row of the table appears
as one line of the file. If it does not contain an absolute path, the file name is relative to
the current working directory.}

\item{instrument}{Which instruments the data was colected with.
Options currently include "Sonde", "EXO", and "HOBO".}

\item{defineVar}{Logical scalar that determines if the units of measurement are included in the first
observation. If they are included, all vectors will be read in as character.}

\item{cleanVar}{Logical scalar. Should the variable names be cleaned to remove spaces and special
characters? This is implemented using the \code{janitor} package's \code{clean_names} function.}

\item{case}{Case to convert variable names to, see \code{janitor::clean_names} for details}
}
\value{
A tibble with the formatted data and the variable types defined if \code{defineVar = TRUE}
}
\description{
This function imports the raw data from a YSI Sonde 6600 and EXO2
    as well as an Onset U24 Conductivity Logger and formats the data set as a tibble.
    If \code{defineVar} is set to \code{TRUE} (the default option), units of measurement will not be
    included in the first observation.
}
\examples{
\dontrun{
dr_read("data.csv", instrument = Sonde, defineVar = TRUE, cleanVar = TRUE, case = "snake")
dr_read("data.csv", instrument = EXO, defineVar = TRUE, cleanVar = TRUE, case = "lower_camel")
dr_read("data.csv", instrument = HOBO, defineVar = TRUE, cleanVar = TRUE, case = "all_caps")
}

}
