% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drglm_multinom.R
\name{drglm.multinom}
\alias{drglm.multinom}
\title{Fitting Multinomial Logistic Regression model in "Divide and Recombine" approach to Large Data Sets}
\usage{
drglm.multinom(formula, data, k)
}
\arguments{
\item{formula}{An entity belonging to the "formula" class (or one that can be transformed into that class) represents a symbolic representation of the model that needs to be adjusted. Specifics about how the model is defined can be found in the 'Details' section.}

\item{data}{A data frame, list, or environment that is not required but can be provided if available.}

\item{k}{Number of subsets to be used.}
}
\value{
A "Multinomial (Polytomous) Logistic Regression  Model" is fitted in "Divide and Recombine" approach.
}
\description{
Function \code{drglm.multinom} fits multinomial logistic regressiosn model to big data sets in divide and recombine approach.
}
\examples{
set.seed(123)
#Number of rows to be generated
n <- 10000
#creating dataset
dataset <- data.frame( pred_1 = round(rnorm(n, mean = 50, sd = 10)),
pred_2 = round(rnorm(n, mean = 7.5, sd = 2.1)),
pred_3 = as.factor(sample(c("0", "1"), n, replace = TRUE)),
pred_4 = as.factor(sample(c("0", "1", "2"), n, replace = TRUE)),
pred_5 = as.factor(sample(0:15, n, replace = TRUE)),
pred_6 = round(rnorm(n, mean = 60, sd = 5)))
#fitting multinomial logistic regression model
mmodel=drglm::drglm.multinom(
pred_4~ pred_1+ pred_2+ pred_3+ pred_5+ pred_6, data=dataset, k=10)
#Output
mmodel
}
\references{
Karim, M. R., & Islam, M. A. (2019). Reliability and Survival Analysis. In Reliability and Survival Analysis.
Venables WN, Ripley BD (2002). Modern Applied Statistics with S, Fourth edition. Springer, New York. ISBN 0-387-95457-0, https://www.stats.ox.ac.uk/pub/MASS4/.
}
\seealso{
\code{\link{big.drglm}}, \code{\link{drglm}}
}
\author{
MH Nayem
}
