% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_perc_effect.R
\name{post_perc_effect}
\alias{post_perc_effect}
\alias{post_perc_effect.dreamer_bma}
\alias{post_perc_effect.dreamer_mcmc}
\title{Calculate Posterior of a Dose's Percentage Effect}
\usage{
post_perc_effect(
  x,
  dose,
  probs,
  time,
  lower,
  upper,
  greater,
  small_bound,
  index,
  return_samples
)

\method{post_perc_effect}{dreamer_bma}(
  x,
  dose,
  probs = c(0.025, 0.975),
  time = NULL,
  lower = min(x$doses),
  upper = max(x$doses),
  greater = TRUE,
  small_bound = 0,
  index = NA,
  return_samples = FALSE
)

\method{post_perc_effect}{dreamer_mcmc}(
  x,
  dose,
  probs = c(0.025, 0.975),
  time = NULL,
  lower = min(attr(x, "doses")),
  upper = max(attr(x, "doses")),
  greater = TRUE,
  small_bound = 0,
  index = 1:(nrow(x[[1]]) * length(x)),
  return_samples = FALSE
)
}
\arguments{
\item{x}{output from a call to \code{dreamer_mcmc()}, or
the MCMC samples from a single model of output from
a \code{dreamer_mcmc()} call.}

\item{dose}{the dose at which to calculate the posterior percentage
effect.}

\item{probs}{a vector of quantiles to calculate on the posterior.}

\item{time}{the slice of time for which to calculate the posterior
percentage effect.  Applies to longitudinal models only.}

\item{lower}{the lower bound of the dose range under consideration.}

\item{upper}{the upper bound of the dose range under consideration.}

\item{greater}{logical indicating if the response is desired to
be increasing (\code{TRUE}) or decreasing (\code{FALSE}).}

\item{small_bound}{the lower (if \code{greater = TRUE}) or upper
(if \code{greater = FALSE}) bound that the effect is expected to
take.}

\item{index}{an index on which MCMC samples should be used.  Generally
the user should not specify anything for this argument as \code{dreamer}
will handle this automatically.}

\item{return_samples}{logical indicating if the posterior samples should
be returned.}
}
\value{
A named list with the following components:
\itemize{
\item stats: a tibble listing the dose, time (where relevant),
probability a percentage effect exists, the average percentage effect,
and the specified quantiles of the percentage effect.
\item samps: a tibble with the posterior samples for each dose/time
combination.
}
}
\description{
Given a dose, the "percentage effect" is defined as
(effect of the given dose - small_bound) / (maximum effect in dose range -
small_bound).  This function returns the posterior statistics and/or
samples of this effect.
}
\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = 3,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
 data = data,
 n_adapt = 1e3,
 n_burn = 1e3,
 n_iter = 1e3,
 n_chains = 2,
 silent = FALSE,
 mod_linear = model_linear(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 ),
 mod_quad = model_quad(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   mu_b3 = 0,
   sigma_b3 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 )
)

post_perc_effect(output, dose = c(3, 5))

# from a single model
post_perc_effect(output$mod_linear, dose = c(3, 5))
}
