% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan.R
\name{drake_plan}
\alias{drake_plan}
\title{Create a workflow plan data frame
for the \code{plan} argument of \code{\link[=make]{make()}}.
\lifecycle{maturing}}
\usage{
drake_plan(..., list = character(0), file_targets = NULL,
  strings_in_dots = NULL, tidy_evaluation = NULL, transform = TRUE,
  trace = FALSE, envir = parent.frame(), tidy_eval = TRUE,
  max_expand = NULL)
}
\arguments{
\item{...}{A collection of symbols/targets
with commands assigned to them. See the examples for details.}

\item{list}{Deprecated}

\item{file_targets}{Deprecated.}

\item{strings_in_dots}{Deprecated.}

\item{tidy_evaluation}{Deprecated. Use \code{tidy_eval} instead.}

\item{transform}{Logical, whether to transform the plan
into a larger plan with more targets.
Requires the \code{transform} field in
\code{target()}. See the examples for details.}

\item{trace}{Logical, whether to add columns to show
what happens during target transformations.}

\item{envir}{Environment for tidy evaluation.}

\item{tidy_eval}{Logical, whether to use tidy evaluation
(e.g. unquoting/\code{!!}) when resolving commands.
Tidy evaluation in transformations is always turned on
regardless of the value you supply to this argument.}

\item{max_expand}{Positive integer, optional upper bound on the lengths
of grouping variables for \code{map()} and \code{cross()}. Comes in handy
when you have a massive number of targets and you want to test
on a miniature version of your workflow before you scale up
to production.}
}
\value{
A data frame of targets, commands, and optional
custom columns.
}
\description{
A \code{drake} plan is a data frame with columns
\code{"target"} and \code{"command"}. Each target is an R object
produced in your workflow, and each command is the
R code to produce it.
}
\details{
Besides \code{"target"} and \code{"command"}, \code{\link[=drake_plan]{drake_plan()}}
understands a special set of optional columns. For details, visit
\url{https://ropenscilabs.github.io/drake-manual/plans.html#special-custom-columns-in-your-plan} # nolint
}
\section{Columns}{

\code{\link[=drake_plan]{drake_plan()}} creates a special data frame. At minimum, that data frame
must have columns \code{target} and \code{command} with the target names and the
R code chunks to build them, respectively.

You can add custom columns yourself, either with \code{target()} (e.g.
\code{drake_plan(y = target(f(x), transform = map(c(1, 2)), format = "fst"))})
or by appending columns post-hoc (e.g. \code{plan$col <- vals}).

Some of these custom columns are special. They are optional,
but \code{drake} looks for them at various points in the workflow.
\itemize{
\item \code{transform}: a call to \code{\link[=map]{map()}}, \code{\link[=split]{split()}}, \code{\link[=cross]{cross()}}, or
\code{\link[=combine]{combine()}} to create and manipulate large collections of targets.
Details: (\url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}). # nolint
\item \code{format}: set a storage format to save big targets more efficiently.
Most formats are faster than ordinary storage, and they consume
far less memory. Available formats:
\itemize{
\item \code{"fst"}: save big data frames fast. The target must be a data frame,
and you must have the \code{fst} package installed.
\item \code{"keras"}: save Keras models as HDF5 files.
Requires the \code{keras} package.
\item \code{"rds"}: save any object. This is similar to the default storage
except we avoid creating a serialized copy of
the entire target in memory.
Requires R >= 3.5.0 so drake can use ALTREP.
}
\item \code{trigger}: rule to decide whether a target needs to run.
It is recommended that you define this one with \code{target()}.
Details: \url{https://ropenscilabs.github.io/drake-manual/triggers.html}.
\item \code{hpc}: logical values (\code{TRUE}/\code{FALSE}/\code{NA}) whether to send each target
to parallel workers.
Visit \url{https://ropenscilabs.github.io/drake-manual/hpc.html#selectivity}
to learn more.
\item \code{resources}: target-specific lists of resources for a computing cluster.
See
\url{https://ropenscilabs.github.io/drake-manual/hpc.html#advanced-options}
for details.
\item \code{elapsed} and \code{cpu}: number of seconds to wait for the target to build
before timing out (\code{elapsed} for elapsed time and \code{cpu} for CPU time).
\item \code{retries}: number of times to retry building a target
in the event of an error.
\item \code{seed}: an optional pseudo-random number generator (RNG)
seed for each target. \code{drake} usually comes up with its own
unique reproducible target-specific seeds using the global seed
(the \code{seed} argument to \code{\link[=make]{make()}} and \code{\link[=drake_config]{drake_config()}})
and the target names, but you can overwrite these automatic seeds.
\code{NA} entries default back to \code{drake}'s automatic seeds.
}
}

\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: give the target more than just a command.
Using \code{\link[=target]{target()}}, you can apply a transformation
(examples: \url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}), # nolint
supply a trigger (\url{https://ropenscilabs.github.io/drake-manual/triggers.html}), # nolint
or set any number of custom columns.
\item \code{\link[=map]{map()}}: create multiple targets. Called inside \code{\link[=target]{target()}}.
\item \code{\link[=split]{split()}}: create a target for each subset of data.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=cross]{cross()}}: create a target for each combination of values.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=combine]{combine()}}: aggregate groups of targets into other targets.
Called inside \code{\link[=target]{target()}}.
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\code{*.Rmd}) or R LaTeX (\code{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\section{DSL}{

\code{drake} has special syntax for generating large plans.
Your code will look something like
\code{drake_plan(x = target(cmd, transform = f(y, z), group = g)}
where \code{f()} is either \code{map()}, \code{cross()}, \code{split()}, or \code{combine()}
(similar to \code{purrr::pmap()}, \code{tidy::crossing()}, \code{base::split()},
and  \code{dplyr::summarize()}, respectively).
These verbs mimic Tidyverse behavior to scale up
existing plans to large numbers of targets.
You can read about this interface at
\url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}. # nolint
}

\examples{
\dontrun{
isolate_example("contain side effects", {
# For more examples, visit
# https://ropenscilabs.github.io/drake-manual/plans.html.

# Create drake plans:
mtcars_plan <- drake_plan(
  write.csv(mtcars[, c("mpg", "cyl")], file_out("mtcars.csv")),
  value = read.csv(file_in("mtcars.csv"))
)
mtcars_plan
make(mtcars_plan) # Makes `mtcars.csv` and then `value`
head(readd(value))
# You can use knitr inputs too. See the top command below.

load_mtcars_example()
head(my_plan)

# The `knitr_in("report.Rmd")` tells `drake` to dive into the active
# code chunks to find dependencies.
# There, `drake` sees that `small`, `large`, and `coef_regression2_small`
# are loaded in with calls to `loadd()` and `readd()`.
deps_code("report.Rmd")

# Formats are great for big data: https://github.com/ropensci/drake/pull/977
# Below, each target is 1.6 GB in memory.
# Run make() on this plan to see how much faster fst is!
n <- 1e8
plan <- drake_plan(
  data_fst = target(
    data.frame(x = runif(n), y = runif(n)),
    format = "fst"
  ),
  data_old = data.frame(x = runif(n), y = runif(n))
)

# Use transformations to generate large plans.
# Read more at
# <https://ropenscilabs.github.io/drake-manual/plans.html#create-large-plans-the-easy-way>. # nolint
drake_plan(
  data = target(
    simulate(nrows),
    transform = map(nrows = c(48, 64)),
    custom_column = 123
  ),
  reg = target(
    reg_fun(data),
   transform = cross(reg_fun = c(reg1, reg2), data)
  ),
  summ = target(
    sum_fun(data, reg),
   transform = cross(sum_fun = c(coef, residuals), reg)
  ),
  winners = target(
    min(summ),
    transform = combine(summ, .by = c(data, sum_fun))
  )
)

# Split data among multiple targets.
drake_plan(
  large_data = get_data(),
  slice_analysis = target(
    large_data \%>\%
      analyze(),
    transform = split(large_data, slices = 4)
  ),
  results = target(
    rbind(slice_analysis),
    transform = combine(slice_analysis)
  )
)

# Set trace = TRUE to show what happened during the transformation process.
drake_plan(
  data = target(
    simulate(nrows),
    transform = map(nrows = c(48, 64)),
    custom_column = 123
  ),
  reg = target(
    reg_fun(data),
   transform = cross(reg_fun = c(reg1, reg2), data)
  ),
  summ = target(
    sum_fun(data, reg),
   transform = cross(sum_fun = c(coef, residuals), reg)
  ),
  winners = target(
    min(summ),
    transform = combine(summ, .by = c(data, sum_fun))
  ),
  trace = TRUE
)

# You can create your own custom columns too.
# See ?triggers for more on triggers.
drake_plan(
  website_data = target(
    command = download_data("www.your_url.com"),
    trigger = "always",
    custom_column = 5
  ),
  analysis = analyze(website_data)
)

# Tidy evaluation can help generate super large plans.
sms <- rlang::syms(letters) # To sub in character args, skip this.
drake_plan(x = target(f(char), transform = map(char = !!sms)))
})
}
}
\seealso{
make, drake_config, transform_plan, map, split, cross, combine
}
