% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-txtplot.R
\name{render_text_drake_graph}
\alias{render_text_drake_graph}
\title{Render a text-based visualization of drake's dependency graph
using the data frames generated by \code{\link[=drake_graph_info]{drake_graph_info()}}.}
\usage{
render_text_drake_graph(graph_info, nchar = 1L, print = TRUE)
}
\arguments{
\item{graph_info}{List of data frames generated by
\code{\link[=drake_graph_info]{drake_graph_info()}}.
There should be 3 data frames: \code{nodes}, \code{edges},
and \code{legend_nodes}.}

\item{nchar}{For each node, maximum number of characters of the node label
to show. Can be 0, in which case each node is a colored box
instead of a node label.
Caution: \code{nchar} > 0 will mess with the layout.}

\item{print}{Logical. If \code{TRUE}, the graph will print to the console
via \code{message()}. If \code{FALSE}, nothing is printed. However, you still
have the visualization because \code{text_drake_graph()} and
\code{render_text_drake_graph()} still invisibly return a character string
that you can print yourself with \code{message()}.}
}
\value{
The lines of text in the visualization.
}
\description{
This function is called inside
\code{\link[=text_drake_graph]{text_drake_graph()}}, which typical users
call more often. See \code{?text_drake_graph} for details.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
pkgs <- requireNamespace("txtplot", quietly = TRUE) &&
  requireNamespace("visNetwork", quietly = TRUE)
if (pkgs) {
# Instead of jumpting right to vis_drake_graph(), get the data frames
# of nodes, edges, and legend nodes.
config <- drake_config(my_plan) # Internal configuration list
text_drake_graph(config) # Jump straight to the interactive graph.
# Get the node and edge info that vis_drake_graph() just plotted:
graph <- drake_graph_info(config)
# You can pass the data frames right to render_text_drake_graph().
render_text_drake_graph(graph)
}
}
})
}
}
\seealso{
\code{\link[=text_drake_graph]{text_drake_graph()}}, \code{\link[=vis_drake_graph]{vis_drake_graph()}},
\code{\link[=sankey_drake_graph]{sankey_drake_graph()}}, \code{\link[=drake_ggraph]{drake_ggraph()}}
}
