% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{load_main_example}
\alias{load_main_example}
\title{Load the main example from \code{drake_example("main")}}
\usage{
load_main_example(envir = parent.frame(), report_file = "report.Rmd",
  overwrite = FALSE, force = FALSE)
}
\arguments{
\item{envir}{The environment to load the example into.
Defaults to your workspace.
For an insulated workspace,
set \code{envir = new.env(parent = globalenv())}.}

\item{report_file}{where to write the report file \code{report.Rmd}.}

\item{overwrite}{logical, whether to overwrite an
existing file \code{report.Rmd}}

\item{force}{logical, whether to force the loading of a
non-back-compatible cache from a previous version of drake.}
}
\value{
A \code{\link[=drake_config]{drake_config()}} configuration list.
}
\description{
The main example itself lives at
\url{https://github.com/wlandau/drake-examples/tree/master/main}. # nolint
Use \code{drake_example("main")} to download the code.
The chapter of the user manual at
\url{https://ropenscilabs.github.io/drake-manual/main.html} # nolint
also walks through the main example.
This function also writes/overwrites
the files \code{report.Rmd} and \code{raw_data.xlsx}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (requireNamespace("downloader")){
# Populate your workspace and write 'report.Rmd' and 'raw_data.xlsx'.
load_main_example() # Get the code: drake_example("main")
# Run the project with make(plan).
# Make sure you have these packages installed first:
# dplyr, forcats, ggplot2, readxl, and rmarkdown
make(plan) # Build the targets.
readd(hist) # Show the ggplot2 histogram.
# Clean up the example.
clean_main_example()
}
})
}
}
\seealso{
\code{\link[=clean_main_example]{clean_main_example()}}
}
