% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_runtime.R
\name{predict_runtime}
\alias{predict_runtime}
\title{Predict the elapsed runtime of the next call to `make()`.}
\usage{
predict_runtime(config, targets = NULL, future_jobs = 1,
  from_scratch = FALSE, targets_only = FALSE, digits = 3)
}
\arguments{
\item{config}{option internal runtime parameter list of
\code{\link{make}(...)},
produced by both \code{\link{make}()} and
\code{\link{drake_config}()}.}

\item{targets}{Character vector, names of targets.
Predict the runtime of building these targets
plus dependencies.
Defaults to all targets.}

\item{future_jobs}{hypothetical number of jobs
assumed for the predicted runtime.
assuming this number of jobs.}

\item{from_scratch}{logical, whether to predict a
\code{\link{make}()} build from scratch or to
take into account the fact that some targets may be
already up to date and therefore skipped.}

\item{targets_only}{logical, whether to factor in
just the targets into the calculations or use the
build times for everything, including the imports}

\item{digits}{number of digits for rounding the time}
}
\value{
A \code{lubridate} \code{Duration} object
with the predicted runtime of the next \code{\link{make}()}.
}
\description{
This function simply sums the elapsed build times
from \code{\link{rate_limiting_times}()}, and this
feature is experimental.
To date, the accuracy/precision of the results
has not yet been confirmed by performance studies.
}
\details{
For the results to make sense, the previous build times
of all targets need to be available (automatically cached
by \code{\link{make}()}). Otherwise, \code{predict_runtime()}
will warn you and tell you which targets have missing times.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
config <- make(my_plan) # Run the project, build the targets.
predict_runtime(config, digits = 4) # Everything is up to date.
predict_runtime(config, digits = 4, from_scratch = TRUE) # 1 job
# Assumes you clean() out your project and start from scratch with 2 jobs.
predict_runtime(config, future_jobs = 2, digits = 4, from_scratch = TRUE)
# Predict the runtime of just building targets
# "small" and "large".
predict_runtime(
  config,
  targets = c("small", "large"),
  from_scratch = TRUE,
  digits = 4
)
})
}
}
\seealso{
\code{\link{rate_limiting_times}},
\code{\link{build_times}}
\code{\link{make}}
}
