% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{in_progress}
\alias{in_progress}
\title{Function \code{in_progress}}
\usage{
in_progress(path = getwd(), search = TRUE, cache = drake::get_cache(path =
  path, search = search, verbose = verbose), verbose = TRUE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}
}
\value{
A character vector of target names
}
\description{
List the targets that either
(1) are currently being built if \code{\link{make}()} is running, or
(2) were in the process of being built if the previous call to
\code{\link{make}()} quit unexpectedly.
}
\examples{
\dontrun{
load_basic_example()
make(my_plan) # Kill before targets finish.
in_progress()
}
}
\seealso{
\code{\link{diagnose}}, \code{\link{session}},
\code{\link{built}}, \code{\link{imported}},
\code{\link{readd}}, \code{\link{workplan}}, \code{\link{make}}
}
