% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_group.R
\name{render_dq_box_group}
\alias{render_dq_box_group}
\title{Directly render a set of dq_boxes as a group}
\usage{
render_dq_box_group(..., open = NULL)
}
\arguments{
\item{...}{a set of dq_boxes}

\item{open}{optional integer or character of length one, specifying the
initially opened box}
}
\value{
fluidRow containing the grouped dq_boxes
}
\description{
Directly render a set of dq_boxes into an uiOutput element. All
given dq_boxes will be prepared automatically, meaning that they become
'collapsible' and 'open_callback'ed.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    fluidRow(column(6, uiOutput("myGroup")))
  ),
  server = function(input, output) {
    output$myGroup <- render_dq_box_group(
      dq_box("Random Input1", dq_space(), "End of Content",
        title = "TestBox1", width = 12),
      dq_box("Random Input2", dq_space(), "End of Content",
        title = "TestBox2", width = 9),
      dq_box("Random Input3", dq_space(), "End of Content",
        title = "TestBox3", width = 12),
      open = 3L)
  }
)

}
}
\author{
richard.kunze
}
