% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hot_helpers.R
\name{dq_add_selectize_options}
\alias{dq_add_selectize_options}
\alias{dq_as_selectize_options}
\title{Adds selectizeOptions to a column of rhandsontable}
\usage{
dq_add_selectize_options(hot, rows, col, options, ...)

dq_as_selectize_options(options, ...)
}
\arguments{
\item{hot}{rhandsontable object}

\item{rows}{vector of row indices, NULL means the whole column will be filled}

\item{col}{column index or name, must be scalar}

\item{options}{character vector or list to be used as selectize options,
names will be used as labels for the options, dq_add_selectize_options can
also handle lists of vectors, where each vector will be used to specify the
options of one cell}

\item{...}{additional parameters to be passed to selectize}
}
\value{
dq_add_selectize_options: updated rhandsontable object

dq_as_selectize_options: list containing all options and additional
settings
}
\description{
dq_add_selectize_options adds selectizeOptions to a column of
a rhandsontable to be used with the selectize editor. Especially useful if
each cell should have individual dropdowns. It will also set the type and
editor for the specified column.

dq_as_selectize_options converts the given vector of options
into a proper selectize options list. Names of the given vector will be used
to specify labels for the options. Further selectize attributes can be set
via additional named parameters.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(rhandsontable)
library(shiny)
hw <- c("Hello", "my", "funny", "world!",
  "Those", "are", "some", "really", "random", "words!")

options <- lapply(1:10, function(x) c(Name1 = sample(hw, 1),
  Name2 = sample(hw, 1), Name3 = sample(hw, 1)))
ch <- sample(hw, 3)
names(ch) <- sample(hw, 3)
selectize <- dq_as_selectize_options(ch, create = TRUE)

empty <- rep("", 10)
df <- data.frame(Unlabled=empty, Labled=empty,
  Multiple=empty, stringsAsFactors = F)

shinyApp(
  ui = fluidPage(
    dq_space(),
    rHandsontableOutput("randomTable")
  ),
  server = function(input, output) {
    output$randomTable <- renderRHandsontable({
      rhandsontable(df, stretchH = "all") \%>\%
        dq_add_selectize_options(NULL, 1, lapply(options, unname)) \%>\%
        hot_col(2, editor = "selectize", selectizeOptions = selectize) \%>\%
        dq_add_selectize_options(NULL, "Multiple", options, maxItems = 2)
    })
  }
)

}
}
\author{
richard.kunze
}
