% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{integrateA}
\alias{integrateA}
\title{Integrate Alternative}
\usage{
integrateA(f, lower, upper, ..., subdivisions = 100L,
  rel.tol = .Machine$double.eps^0.25, abs.tol = rel.tol,
  stop.on.error = TRUE, keep.xy = FALSE, aux = NULL)
}
\arguments{
\item{f, lower, upper, ..., subdivisions, rel.tol, abs.tol, stop.on.error, keep.xy, aux}{see \code{\link[stats]{integrate}}.}
}
\description{
\code{integrateA} is a tolerance wrapper for \code{integrate}.
It allows \code{integrate} to reach the maximum number of subdivisions.
}
\details{
See \code{\link[stats]{integrate}}.
}
\examples{
f = function(x) ifelse(x < 0, cos(x), sin(x))
#curve(f(x), -1, 1)
try(integrate(f, -1, 1, subdivisions=1)$value)
integrateA(f, -1, 1, subdivisions=1)$value
integrateA(f, -1, 1, subdivisions=2)$value
integrateA(f, -1, 1, subdivisions=3)$value
}
\seealso{
\code{\link[stats]{integrate}}
}

