% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taylor.R
\name{taylor}
\alias{taylor}
\title{Taylor expansion (one dimension)}
\usage{
taylor(fn, x0, ord = 1)
}
\arguments{
\item{fn}{A function of one variable and that variable must be named 'x'.}

\item{x0}{The point in which to to the Taylor expansion.}

\item{ord}{The order of the Taylor expansion.}
}
\value{
function.
}
\description{
Returns Taylor polynomial approximating a function fn(x)
}
\examples{
fn <- function(x) log(x)
ord <- 2
x0 <- 2

xv  <- seq(.2, 5, .1)
plot(xv, fn(xv), type="l")
lines(xv, taylor(fn, x0=x0, ord=ord)(xv), lty=2)
abline(v=x0)

fn <- function(x)sin(x)
ord <- 4
x0 <- 0
xv <- seq(-2*pi, 2*pi, 0.1)
plot(xv, fn(xv), type="l")
lines(xv, taylor(fn, x0=x0, ord=ord)(xv), lty=2)
abline(v=x0)


}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
