% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{check_sites}
\alias{check_sites}
\title{Check sites}
\usage{
check_sites(objs, dataset, col_site)
}
\arguments{
\item{objs}{A list of objects.}

\item{dataset}{A dataset, a type is a data frame.}

\item{col_site}{A column name of a site in the dataset, without quotes.}
}
\value{
A list of objects with a check result.
}
\description{
Check sites
}
\examples{
site <- c("site 01", "site 02")
id <- c("01", "02")
age <- c("19", "20")
sex <- c("f", "m")
gluc_post <- c("5.5", "4.1")
gluc_res_post <- c("norm", "no")
ast_post <- c("30", "48")
ast_res_post <- c(NA, "norm")

df <- data.frame(
  site, id, age, sex,
  gluc_post, gluc_res_post,
  ast_post, ast_res_post,
  stringsAsFactors = FALSE
)

refs_s01 <- system.file("labs_refer_s01.xlsx", package = "dmtools")
refs_s02 <- system.file("labs_refer_s02.xlsx", package = "dmtools")

s01_lab <- lab(refs_s01, id, age, sex, "norm", "no", site = "site 01")
s02_lab <- lab(refs_s02, id, age, sex, "norm", "no", site = "site 02")

labs <- list(s01_lab, s02_lab)
labs <- check_sites(labs, df, site)
}
