fgls.iter.siga <-
function (am, start.siga, mmat, dyad.explist, evec, dmefglsopt, 
    dmeopt, ctable) 
{
    stopcrit <- 10
    stoptol <- dmefglsopt$stoptol
    maxiter <- dmefglsopt$maxiter
    maxiter <- 100
    bdamp <- dmefglsopt$bdamp
    newsiga <- start.siga
    count <- 0
    degf <- am$n - am$k
    bias <- am$n/degf
    ipkminv <- ginvipk(am$n, am$n)
    ipkminvblock <- kronecker(diag(am$l * am$l), ipkminv)
    xblock <- kronecker(diag(am$l), am$x)
    hblock <- xblock %*% ginv(t(xblock) %*% xblock) %*% t(xblock)
    mmatblock <- diag(am$n * am$l) - hblock
    evecblock <- matrix(evec, am$n * am$n * am$l * am$l, 1)
    ematblock <- kronecker(diag(am$l * am$l), dyad.explist$emat)
    while (stopcrit > stoptol && count < maxiter) {
        cat("Iteration(fgls) round: ", count, "\n")
        oldsiga <- newsiga
        v <- expect.v(am, oldsiga, dyad.explist)
        newsiga.list <- fgls.update(am, v, mmatblock, ematblock, 
            evecblock, ipkminvblock)
        newsiga <- newsiga.list$siga
        newsiga <- oldsiga + (newsiga - oldsiga) * bdamp
        sumdev <- 0
        for (ll in 1:(am$l * am$l)) {
            for (i in 1:am$v) {
                sumdev <- sumdev + abs(newsiga[i, ll] - oldsiga[i, 
                  ll])
            }
        }
        stopcrit <- sumdev/(am$l * am$l * am$v)
        count <- count + 1
        cat("Round = ", count, " Stopcrit = ", stopcrit, "\n")
    }
    cat("Iteration(fgls) completed - count = ", count, "\n")
    if (count == maxiter) {
        cat("Failed to converge (fgls)\n")
        return()
    }
    cat("Convergence achieved (fgls)\n")
    degfd <- am$n * am$n - am$v
    vsiga <- newsiga.list$vsiga
    diagvsiga <- matrix(diag(vsiga), am$v, am$l * am$l)
    dimnames(diagvsiga) <- dimnames(start.siga)
    cat("diagvsiga:\n")
    print(diagvsiga)
    diagvsiga <- siga.posdef(diagvsiga, am, ctable)
    cat("diagvsiga posdef:\n")
    print(diagvsiga)
    sesiga <- sqrt(diagvsiga)
    cat("sesiga:\n")
    print(sesiga)
    dimnames(newsiga) <- dimnames(start.siga)
    dimnames(sesiga) <- dimnames(start.siga)
    fitted.values <- dyad.explist$emat %*% newsiga
    resid.values <- evec - fitted.values
    dme.fit.fgls <- list(y = evec, coefficients = newsiga, residuals = resid.values, 
        fitted.values = fitted.values)
    parlist <- c(list(siga = newsiga, sesiga = sesiga, vsiga = vsiga), 
        dme.fit.fgls)
    return(parlist)
}
