% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_unnest_tbl.R
\name{dm_unpack_tbl}
\alias{dm_unpack_tbl}
\title{Unpack columns from a wrapped table}
\usage{
dm_unpack_tbl(dm, child_table, col, ptype)
}
\arguments{
\item{dm}{A dm.}

\item{child_table}{A table in the dm with packed columns.}

\item{col}{The column to unpack (unquoted).}

\item{ptype}{A dm, only used to query names of primary and foreign keys.}
}
\description{
#' @description
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
\code{dm_unpack_tbl()} targets a specific column to unpack
from the given table in a given dm.
A ptype or a set of keys should be given,
not both.

\code{\link[=dm_pack_tbl]{dm_pack_tbl()}} is an inverse operation to \code{dm_unpack_tbl()}
if differences in row and column order are ignored.
The opposite is true if referential constraints between both tables
are satisfied
and if all rows in the parent table have at least one child row,
i.e. if the relationship is of cardinality 1:n or 1:1.
}
\examples{
flights_wrapped <-
  dm_nycflights13() \%>\%
  dm_wrap_tbl(flights)

# The ptype is required for reconstruction.
# It can be an empty dm, only primary and foreign keys are considered.
ptype <- dm_ptype(dm_nycflights13())

flights_wrapped \%>\%
  dm_unpack_tbl(flights, airlines, ptype)
}
\seealso{
\code{\link[=dm_unwrap_tbl]{dm_unwrap_tbl()}}, \code{\link[=dm_unnest_tbl]{dm_unnest_tbl()}},
\code{\link[=dm_nest_tbl]{dm_nest_tbl()}}, \code{\link[=dm_pack_tbl]{dm_pack_tbl()}}, \code{\link[=dm_wrap_tbl]{dm_wrap_tbl()}},
\code{\link[=dm_examine_constraints]{dm_examine_constraints()}}, \code{\link[=dm_examine_cardinalities]{dm_examine_cardinalities()}},
\code{\link[=dm_ptype]{dm_ptype()}}.
}
