% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_tbl_dbi.R
\name{diagnose_paged_report.tbl_dbi}
\alias{diagnose_paged_report.tbl_dbi}
\title{Reporting the information of data diagnosis for table of the DBMS}
\usage{
\method{diagnose_paged_report}{tbl_dbi}(
  .data,
  output_format = c("pdf", "html")[1],
  output_file = NULL,
  output_dir = tempdir(),
  browse = TRUE,
  title = "Data Diagnosis Report",
  subtitle = deparse(substitute(.data)),
  author = "dlookr",
  abstract_title = "Report Overview",
  abstract = NULL,
  title_color = "white",
  subtitle_color = "gold",
  thres_uniq_cat = 0.5,
  thres_uniq_num = 5,
  flag_content_zero = TRUE,
  flag_content_minus = TRUE,
  flag_content_missing = TRUE,
  cover_img = NULL,
  create_date = Sys.time(),
  logo_img = NULL,
  theme = c("orange", "blue")[1],
  sample_percent = 100,
  in_database = FALSE,
  collect_size = Inf,
  as_factor = TRUE,
  ...
)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{output_format}{report output type. Choose either "pdf" and "html".
"pdf" create pdf file by rmarkdown::render() and pagedown::chrome_print(). so, 
you needed Chrome web browser on computer.  
"html" create html file by rmarkdown::render().}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{browse}{logical. choose whether to output the report results to the browser.}

\item{title}{character. title of report. default is "Data Diagnosis Report".}

\item{subtitle}{character. subtitle of report. default is name of data.}

\item{author}{character. author of report. default is "dlookr".}

\item{abstract_title}{character. abstract title of report. default is 
"Report Overview".}

\item{abstract}{character. abstract of report.}

\item{title_color}{character. color of title. default is "white".}

\item{subtitle_color}{character. color of title. default is "gold".}

\item{thres_uniq_cat}{numeric. threshold to use for "Unique Values - 
Categorical Variables". default is 0.5.}

\item{thres_uniq_num}{numeric. threshold to use for "Unique Values - 
Numerical Variables". default is 5.}

\item{flag_content_zero}{logical. whether to output "Zero Values" information. 
the default value is TRUE, and the information is displayed.}

\item{flag_content_minus}{logical. whether to output "Minus Values" information. 
the default value is TRUE, and the information is displayed.}

\item{flag_content_missing}{logical. whether to output "Missing Value" information. 
the default value is TRUE, and the information is displayed.}

\item{cover_img}{character. name of cover image.}

\item{create_date}{Date or POSIXct, character. The date on which the report is generated. 
The default value is the result of Sys.time().}

\item{logo_img}{character. name of logo image on top right.}

\item{theme}{character. name of theme for report. support "orange" and "blue". 
default is "orange".}

\item{sample_percent}{numeric. Sample percent of data for performing Diagnosis. 
It has a value between (0, 100]. 100 means all data, and 5 means 5\% of sample data.
This is useful for data with a large number of observations.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}

\item{as_factor}{logical. whether to convert to factor when importing a character type variable from DBMS table into R.}

\item{...}{arguments to be passed to pagedown::chrome_print().}
}
\description{
The diagnose_paged_report() paged report the information 
for diagnosing the quality of the DBMS table through tbl_dbi.
}
\details{
Generate generalized data diagnostic reports automatically.
You can choose to output to pdf and html files.
This is useful for diagnosing a data frame with a large number of variables
than data with a small number of variables.

Create an  PDF through the Chrome DevTools Protocol. If you want to create PDF, 
Google Chrome or Microsoft Edge (or Chromium on Linux) must be installed prior to using this function.
If not installed, you must use output_format = "html".
}
\section{Reported information}{

Reported from the data diagnosis is as follows.

\itemize{
  \item Overview
  \itemize{
    \item Data Structures 
    \item Job Informations
    \item Warnings
    \item Variables
  } 
  \item Missing Values
  \itemize{
    \item List of Missing Values
    \item Visualization
  } 
  \item Unique Values
  \itemize{
    \item Categorical Variables
    \item Numerical Variables
  } 
  \item Categorical Variable Diagnosis
  \itemize{
     \item Top Ranks
  }
  \item Numerical Variable Diagnosis
  \itemize{
    \item Distribution
    \itemize{
      \item Zero Values
      \item Minus Values
    }
    \item Outliers
    \itemize{
      \item List of Outliers
      \item Individual Outliers
    }
  }
}
}

\examples{
\donttest{
if (FALSE) {
library(dplyr)

# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "platelets"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy heartfailure2 to the DBMS with a table named TB_HEARTFAILURE
copy_to(con_sqlite, heartfailure2, name = "TB_HEARTFAILURE", overwrite = TRUE)

# reporting the diagnosis information -------------------------
# create pdf file. file name is Diagnosis_Paged_Report.pdf
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  diagnose_paged_report()
  
# create pdf file. file name is Diagn.pdf, and collect size is 250
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  diagnose_paged_report(collect_size = 250, output_file = "Diagn.pdf")
  
# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)
}
}

}
\seealso{
\code{\link{diagnose_paged_report.data.frame}}.
}
