% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_class}
\alias{get_class}
\title{Extracting a class of variables}
\usage{
get_class(df)
}
\arguments{
\item{df}{a data.frame or objects inheriting from data.frame}
}
\value{
a data.frame
Variables of data.frame is as follows.
\itemize{
\item variable : variables name
\item class : class of variables
}
}
\description{
The get_class() gets class of variables in data.frame or tbl_df.
}
\examples{
\dontrun{
# data.frame
get_class(iris)

# tbl_df
get_class(ggplot2::diamonds)

library(dplyr)
ggplot2::diamonds \%>\%
  get_class() \%>\% 
  filter(class \%in\% c("integer", "numeric"))
}
}
\seealso{
\code{\link{find_class}}.
}
