% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links_wf.R
\name{link_wf}
\alias{link_wf}
\alias{links_af_probabilistic}
\alias{links_wf}
\alias{links_wf_probabilistic}
\alias{prob_score_range}
\title{Record linkage}
\usage{
links_af_probabilistic(
  attribute,
  blocking_attribute = NULL,
  cmp_func = diyar::exact_match,
  attr_threshold = 1,
  probabilistic = TRUE,
  m_probability = 0.95,
  u_probability = NULL,
  score_threshold = 1,
  repeats_allowed = FALSE,
  permutations_allowed = FALSE,
  data_source = NULL,
  ignore_same_source = TRUE,
  display = "none"
)

links_wf_probabilistic(
  attribute,
  blocking_attribute = NULL,
  cmp_func = diyar::exact_match,
  attr_threshold = 1,
  probabilistic = TRUE,
  m_probability = 0.95,
  u_probability = NULL,
  score_threshold = 1,
  id_1 = NULL,
  id_2 = NULL,
  return_weights = FALSE,
  ...
)

prob_score_range(attribute, m_probability = 0.95, u_probability = NULL)
}
\arguments{
\item{attribute}{\code{[atomic|list|data.frame|matrix|d_attribute]}. Attributes to compare.}

\item{blocking_attribute}{\code{[atomic]}. Passed to \bold{\code{criteria}} in \bold{\code{\link{links}}}.}

\item{cmp_func}{\code{[list|function]}. String comparators for each \code{attribute}. See \code{Details}.}

\item{attr_threshold}{\code{[list|numeric|\link{number_line}]}. Weight-thresholds for each \code{cmp_func}. See \code{Details}.}

\item{probabilistic}{\code{[logical]}. If \code{TRUE}, scores are assigned base on Fellegi-Sunter model for probabilistic record linkage. See \code{Details}.}

\item{m_probability}{\code{[list|numeric]}. The probability that a matching records are the same entity.}

\item{u_probability}{\code{[list|numeric]}. The probability that a matching records are not the same entity.}

\item{score_threshold}{\code{[numeric|\link{number_line}]}. Score-threshold for linked records. See \code{Details}.}

\item{repeats_allowed}{\code{[logical]} Passed to \bold{\code{repeats_allowed}} in \bold{\code{\link{links}}}.}

\item{permutations_allowed}{\code{[logical]} Passed to \bold{\code{permutations_allowed}} in \bold{\code{\link{links}}}.}

\item{data_source}{\code{[character]}. Passed to \bold{\code{data_source}} in \bold{\code{\link{links}}}.}

\item{ignore_same_source}{\code{[logical]} Passed to \bold{\code{ignore_same_source}} in \bold{\code{\link{links}}}.}

\item{display}{\code{[character]}. Passed to \bold{\code{display}} in \bold{\code{\link{links}}}.}

\item{id_1}{\code{[list|numeric]}. Record id or index of one half of a record-pair.}

\item{id_2}{\code{[list|numeric]}. Record id or index of one half of a record-pair.}

\item{return_weights}{If \code{TRUE}, returns the match-weights and score-thresholds for record pairs.}

\item{...}{Arguments passed to \bold{\code{links}}}
}
\value{
\code{\link[=pid-class]{pid}}; \code{list}
}
\description{
Deterministic and probabilistic record linkage
Assign unique identifiers to records based on partial, nested or calculated probabilities.
}
\details{
\bold{\code{links_wf_probabilistic()}} - A wrapper function of \code{\link{links}} with a
with a specific \code{\link{sub_criteria}} and to achieve to achieve probabilistic record linkage
It excludes functionalities for the nested and multi-stage linkage.
 \code{links_wf_probabilistic()} requires a \code{score_threshold} in advance.
To help with this, \code{prob_score_range()} can be used to return the range of scores attainable for a given set of \code{attribute}, \code{m} and \code{u}-probabilities.
Additionally, \code{id_1} and \code{id_2} can be used to link specific records pairs, aiding the review of potential scores.


\bold{\code{links_af_probabilistic()}} - A simpler version of \code{\link{links}}.
It excludes functionalities for the batched, nested and multi-stage linkage.
\code{links_af_probabilistic()} requires a \code{score_threshold} in advance,
however, since it exports the match weights, the \code{score_threshold}
can be changed after the analysis.
}
\examples{
data(patient_records)
# Weighted (probabilistic) comparison of forename, middlename and surname
criteria_1 <- as.list(patient_records[c("forename", "middlename", "surname")])

# Possible scores when m-probability is 0.95
prob_scores <- prob_score_range(attribute = criteria_1,
                                m_probability = 0.95,
                                u_probability = NULL)
\dontrun{
# Probabilistic record linkage with 'links_af_probabilistic()'
pids_1a <- links_af_probabilistic(attribute = criteria_1,
                        cmp_func = exact_match,
                        attr_threshold = 1,
                        probabilistic = TRUE,
                        m_probability = 0.95,
                        score_threshold = prob_scores$mid_scorce,
                        display = "stats")

# Equivalent with 'links_wf_probabilistic()'
pids_1b <- links_wf_probabilistic(attribute = criteria_1,
                                  cmp_func = exact_match,
                                  attr_threshold = 1,
                                  probabilistic = TRUE,
                                  m_probability = 0.95,
                                  score_threshold = prob_scores$mid_scorce,
                                  display = "progress",
                                  recursive = TRUE,
                                  check_duplicates = TRUE)

# Less thorough but faster equivalent with `links_wf_probabilistic()`
pids_1c <- links_wf_probabilistic(attribute = criteria_1,
                                  cmp_func = exact_match,
                                  attr_threshold = 1,
                                  probabilistic = TRUE,
                                  m_probability = 0.95,
                                  score_threshold = prob_scores$mid_scorce,
                                  display = "progress",
                                  recursive = FALSE,
                                  check_duplicates = FALSE)

# Each implementation can lead to different results
summary(pids_1a$pid)
summary(pids_1b$pid)
summary(pids_1c$pid)
}

# Weighted (non-probabilistic) comparison of forename, middlename and age difference
criteria_2 <- as.list(patient_records[c("forename", "middlename", "dateofbirth")])
age_diff <- function(x, y){
  diff <- abs(as.numeric(x) - as.numeric(y))
  wgt <-  diff \%in\% 0:(365 * 10) & !is.na(diff)
  wgt
}

pids_2a <- links_af_probabilistic(attribute = criteria_2,
                        blocking_attribute = patient_records$surname,
                        cmp_func = c(exact_match, exact_match, age_diff),
                        score_threshold = number_line(3, 5),
                        probabilistic = FALSE,
                        display = "stats")

# Larger weights can be assigned to particular attributes through `cmp_func`
# For example, a smaller age difference can contribute a higher score (e.g 0 to 3)
age_diff_2 <- function(x, y){
  diff <- as.numeric(abs(x - y))
  wgt <-  diff \%in\% 0:(365 * 10) & !is.na(diff)
  wgt[wgt] <- match(as.numeric(cut(diff[wgt], 3)), 3:1)
  wgt
}
pids_2b <- links_af_probabilistic(attribute = criteria_2,
                        blocking_attribute = patient_records$surname,
                        cmp_func = c(exact_match, exact_match, age_diff_2),
                        score_threshold = number_line(3, 5),
                        probabilistic = FALSE,
                        display = "stats")

head(pids_2a$pid_weights, 10)
head(pids_2b$pid_weights, 10)

}
\references{
Fellegi, I. P., & Sunter, A. B. (1969). A Theory for Record Linkage. \emph{Journal of the Statistical Association}, 64(328), 1183 - 1210. https://doi.org/10.1080/01621459.1969.10501049

Asher, J., Resnick, D., Brite, J., Brackbill, R., & Cone, J. (2020). An Introduction to Probabilistic Record Linkage with a Focus on Linkage Processing for WTC Registries. \emph{International journal of environmental research and public health}, 17(18), 6937. https://doi.org/10.3390/ijerph17186937.
See \code{vignette("links")} for more information.
}
\seealso{
\code{\link{links}}
}
