% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diversity.R
\name{sim_entity}
\alias{sim_entity}
\title{A procedure to simulate entities}
\usage{
sim_entity(n_categ, category_prefix = "", values = "log-normal",
  size = -1, mean = 0, sd = 1)
}
\arguments{
\item{n_categ}{number of categories}

\item{category_prefix}{a prefix to be used as part of the category label}

\item{values}{values of abundance. This argument can be both, a distribution name or a vector of integers. The distribution is used to simulate individuals that are aggregated in frequencies or values of abundance. In the second case, an integer or a vector of integers of possible values of abundance to be used randomly. Default value is 'log-normal'}

\item{size}{number of individuals. Default value is 7 times n_categ.}

\item{mean}{parameter for normal or log-normal distribution. Default value is 0.}

\item{sd}{parameter for normal or log-normal distribution. Default value is 1.}
}
\value{
A data frame with two columns: category and value of abundance.
}
\description{
Simulates an entity with values of abundance for some categories.
}
\examples{
sim_entity(n_categ=50,  category_prefix='ctg', values=1) #equal value
#random numbers for values of abundance
sim_entity(n_categ=50,  category_prefix='ctg', values=sample(1:100, replace=TRUE))
sim_entity(n_categ=50,  category_prefix='ctg', values='log-normal') #equal value
}

