% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ent_hurlbert.R
\name{ent_hurlbert}
\alias{ent_hurlbert}
\alias{ent_hurlbert.numeric}
\alias{ent_hurlbert.species_distribution}
\title{Hurlbert Entropy of a Community}
\usage{
ent_hurlbert(x, k = 2, ...)

\method{ent_hurlbert}{numeric}(
  x,
  k = 2,
  estimator = c("Hurlbert", "naive"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{ent_hurlbert}{species_distribution}(
  x,
  k = 2,
  estimator = c("Hurlbert", "naive"),
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{k}{The order of Hurlbert's diversity.}

\item{...}{Unused.}

\item{estimator}{An estimator of entropy.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A tibble with the site names, the estimators used and the estimated entropy.
}
\description{
Estimate the Hurlbert entropy \insertCite{Hurlbert1971}{divent} of species from abundance or probability data.
Several estimators are available to deal with incomplete sampling.
}
\details{
Bias correction requires the number of individuals.
See \link{div_hurlbert} for estimators.

Hurlbert's entropy cannot be estimated at a specified level of interpolation or
extrapolation, and entropy partitioning is not available.
}
\examples{
# Entropy of each community
ent_hurlbert(paracou_6_abd, k = 2)

}
\references{
\insertAllCited{}
}
