% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R, R/dbExistsTable.R,
%   R/dbListTables-Fields.R, R/dbQueries-Results.R, R/dbMisc.R, R/quote.R,
%   R/transactions.R
\docType{class}
\name{mock-db-methods}
\alias{mock-db-methods}
\alias{DBIMockConnection-class}
\alias{dbDisconnect,DBIMockConnection-method}
\alias{dbMockConnect}
\alias{dbExistsTable,DBIMockConnection,character-method}
\alias{dbExistsTable,DBIMockConnection,Id-method}
\alias{dbListTables,DBIMockConnection-method}
\alias{dbListFields,DBIMockConnection,character-method}
\alias{dbListFields,DBIMockConnection,Id-method}
\alias{dbListFields,DBIMockConnection,ANY-method}
\alias{DBIMockResult-class}
\alias{dbSendQuery,DBIMockConnection,character-method}
\alias{dbSendQuery,DBIMockConnection,SQL-method}
\alias{dbSendStatement,DBIMockConnection,character-method}
\alias{dbFetch,DBIMockResult-method}
\alias{fetch,DBIMockResult,ANY-method}
\alias{fetch,DBIMockResult-method}
\alias{fetch,DBIMockResult,missing-method}
\alias{dbClearResult,DBIMockResult-method}
\alias{dbHasCompleted,DBIMockResult-method}
\alias{dbGetQuery,DBIMockRPostgreSQLConnection,character-method}
\alias{dbGetRowsAffected,DBIMockResult-method}
\alias{dbGetInfo,DBIMockConnection-method}
\alias{dbWriteTable,DBIMockConnection,character,data.frame-method}
\alias{dbRemoveTable,DBIMockConnection,character-method}
\alias{dbColumnInfo,DBIMockResult-method}
\alias{dbGetInfo,DBIMockResult-method}
\alias{dbQuoteIdentifier,DBIMockRPostgresConnection,character-method}
\alias{dbQuoteIdentifier,DBIMockRPostgresConnection,SQL-method}
\alias{dbQuoteString,DBIMockRPostgresConnection,character-method}
\alias{dbQuoteString,DBIMockRPostgresConnection,SQL-method}
\alias{dbQuoteString,DBIMockMariaDBConnection,character-method}
\alias{dbQuoteString,DBIMockMariaDBConnection,SQL-method}
\alias{dbBegin,DBIMockConnection-method}
\alias{dbCommit,DBIMockConnection-method}
\alias{dbRollback,DBIMockConnection-method}
\title{Methods for interacting with DB mocks instead of an actual database}
\usage{
\S4method{dbDisconnect}{DBIMockConnection}(conn, ...)

dbMockConnect(drv, ...)

\S4method{dbExistsTable}{DBIMockConnection,character}(conn, name, ...)

\S4method{dbExistsTable}{DBIMockConnection,Id}(conn, name, ...)

\S4method{dbListTables}{DBIMockConnection}(conn, ...)

\S4method{dbListFields}{DBIMockConnection,character}(conn, name, ...)

\S4method{dbListFields}{DBIMockConnection,Id}(conn, name, ...)

\S4method{dbListFields}{DBIMockConnection,ANY}(conn, name, ...)

\S4method{dbSendQuery}{DBIMockConnection,character}(conn, statement, ...)

\S4method{dbSendQuery}{DBIMockConnection,SQL}(conn, statement, ...)

\S4method{dbSendStatement}{DBIMockConnection,character}(conn, statement, ...)

\S4method{dbFetch}{DBIMockResult}(res, n = -1, ...)

\S4method{fetch}{DBIMockResult,ANY}(res, n = -1, ...)

\S4method{fetch}{DBIMockResult,missing}(res, n = -1, ...)

\S4method{dbClearResult}{DBIMockResult}(res, n, ...)

\S4method{dbHasCompleted}{DBIMockResult}(res, ...)

\S4method{dbGetQuery}{DBIMockRPostgreSQLConnection,character}(conn, statement, ...)

\S4method{dbGetRowsAffected}{DBIMockResult}(res, ...)

\S4method{dbGetInfo}{DBIMockConnection}(dbObj, ...)

\S4method{dbWriteTable}{DBIMockConnection,character,data.frame}(conn, name, value, ...)

\S4method{dbRemoveTable}{DBIMockConnection,character}(conn, name, ...)

\S4method{dbColumnInfo}{DBIMockResult}(res, ...)

\S4method{dbGetInfo}{DBIMockResult}(dbObj, ...)

\S4method{dbQuoteIdentifier}{DBIMockRPostgresConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{DBIMockRPostgresConnection,SQL}(conn, x, ...)

\S4method{dbQuoteString}{DBIMockRPostgresConnection,character}(conn, x, ...)

\S4method{dbQuoteString}{DBIMockRPostgresConnection,SQL}(conn, x, ...)

\S4method{dbQuoteString}{DBIMockMariaDBConnection,character}(conn, x, ...)

\S4method{dbQuoteString}{DBIMockMariaDBConnection,SQL}(conn, x, ...)

\S4method{dbBegin}{DBIMockConnection}(conn, ..., name = NULL)

\S4method{dbCommit}{DBIMockConnection}(conn, ..., name = NULL)

\S4method{dbRollback}{DBIMockConnection}(conn, ..., name = NULL)
}
\arguments{
\item{conn}{a database connection (for dispatch with these methods, it should
be of class \code{DBIMockConnection})}

\item{...}{arguments passed on inside of the methods}

\item{drv}{a DB driver for use in \code{\link{dbConnect}}}

\item{name}{name of the table (for \code{\link{dbListFields}}, \code{\link{dbWriteTable}},
\code{\link{dbRemoveTable}})}

\item{statement}{an SQL statement to execute}

\item{res}{a result object (for dispatch with these methods, it should be of
class \code{DBIMockResult})}

\item{n}{number of results to fetch (ignored)}

\item{dbObj}{a database object (a connection, result, etc.) for use in
\code{\link{dbGetInfo}}}

\item{value}{a value (generally a \code{data.frame}) for use in \code{\link{dbWriteTable}}}

\item{x}{a name to quote (for \code{\link{dbQuoteIdentifier}})}
}
\description{
Various methods (\code{dbSendQuery}, \code{dbFetchQuery}) that are mocks of the
\href{https://CRAN.R-project.org/package=DBI}{DBI} methods of the same name.
Instead of actually interacting with a database, they read in mock responses
and the code proceeds after that. These aren't used directly, but are part of
how \code{dittodb} works.
}
