% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NegativeBinomial.R
\name{quantile.NegativeBinomial}
\alias{quantile.NegativeBinomial}
\title{Determine quantiles of a NegativeBinomial distribution}
\usage{
\method{quantile}{NegativeBinomial}(x, probs, ...)
}
\arguments{
\item{x}{A \code{NegativeBinomial} object created by a call to
\code{\link[=NegativeBinomial]{NegativeBinomial()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
Determine quantiles of a NegativeBinomial distribution
}
\examples{

set.seed(27)

X <- NegativeBinomial(10, 0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other NegativeBinomial distribution: 
\code{\link{cdf.NegativeBinomial}()},
\code{\link{pdf.NegativeBinomial}()},
\code{\link{random.NegativeBinomial}()}
}
\concept{NegativeBinomial distribution}
