% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_contents.R
\name{estimate_site_gradient}
\alias{estimate_site_gradient}
\alias{estimate_model}
\title{Estimate Site Gradient}
\usage{
estimate_site_gradient(
  model_name,
  synced_folder,
  site_name = "site1",
  data,
  all_site_names = NULL,
  shuffle_rows = TRUE,
  experimental = FALSE
)

estimate_model(
  model_name,
  synced_folder,
  site_name = "site1",
  data,
  all_site_names = NULL,
  shuffle_rows = TRUE,
  wait_time = 1,
  run_compute = FALSE,
  experimental = FALSE
)
}
\arguments{
\item{model_name}{name of your model}

\item{synced_folder}{synced folder to do computation}

\item{site_name}{name of the site, needs to be one of the
\code{all_site_names}}

\item{data}{dataset to get gradient value from}

\item{all_site_names}{all the site names used to fit this model}

\item{shuffle_rows}{should the rows of the dataset be permuted, so
as to decrease privacy concerns}

\item{experimental}{using the \code{glm} function rather than a
custom-written function}

\item{wait_time}{Time, in seconds, to wait until to try to
get new estimate}

\item{run_compute}{if \code{TRUE}, when estimating the model, it will also
try to run \code{\link{estimate_new_beta}} if all other sites have submitted.
This allows all sites to be a potential computation site.}
}
\value{
A character filename of the gradient file, with the
output from \code{\link{gradient_value}}
}
\description{
Estimate Site Gradient
}
\examples{
data = data.frame(y = c(0, 0, 1),
                  pois_y = c(4, 1, 0),
                  x2 = c(-2.19021287072066,
                         -0.344307138450805, 3.47215796952745),
                  x1 = c(-0.263859503846267,
                         -0.985160029707486, 0.227262373184513))
tdir = tempfile()
dir.create(tdir)
model_name = "logistic_example"
form_file = setup_model(model_name = model_name,
                        synced_folder = tdir,
                        formula =  "y ~ x1 + x2", family =  "binomial")
outfile = estimate_site_gradient(
  model_name = model_name, synced_folder = tdir,
  all_site_names = "site1",
  data = data)
clear_model(model_name, tdir)
testthat::expect_error({
outfile = estimate_site_gradient(
  model_name = model_name, synced_folder = tdir,
  all_site_names = "site1",
  data = data)
})
}
