#' Auto Breaks for Matrix Plotting Functions
#'
#' @param m (required, numeric matrix) distance or cost matrix generated by [psi_distance_matrix()] or [psi_cost_matrix()], but any numeric matrix will work. Default: NULL
#' @param n (required, integer) number of colors to compute the breaks for. Default: 100
#'
#' @return numeric vector
#' @autoglobal
#' @export
#' @family internal_plotting
utils_color_breaks <- function(
    m = NULL,
    n = 100
    ){

  m <- utils_check_args_matrix(m = m)

  m.range <- range(m, na.rm = TRUE)

  a <- seq(
    from = m.range[1],
    to = m.range[2],
    length.out = n
  )

  b <- (a[2]- a[1])/2

  breaks <- c(a[1] - b, a + b)

  breaks

}
