% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_names.R
\name{zoo_name_set}
\alias{zoo_name_set}
\title{Set Name of a Zoo Time Series}
\usage{
zoo_name_set(x = NULL, name = NULL)
}
\arguments{
\item{x}{(required, zoo object) Zoo time series to analyze. Default: NULL.}

\item{name}{(required, character string) name or new name of the zoo object. If NULL, \code{x} is returned as is. Default: NULL}
}
\value{
zoo time series
}
\description{
Zoo time series do not have an attribute 'name'. However, within \code{distantia},  to keep data consistency in several plotting and analysis operations, an attribute 'name' is used for these objects. This function is a convenient wrapper of \code{attr(x = x, which = "name") <- "xxx"}.
}
\examples{
#simulate zoo time series
x <- zoo_simulate()

#get current name
zoo_name_get(x = x)

#change name
x <- zoo_name_set(
  x = x,
  name = "My.New.name"
)

zoo_name_get(x = x)

#clean name
x <- zoo_name_clean(
  x = x,
  lowercase = TRUE
)

zoo_name_get(x = x)
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
