% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cost_path_cpp}
\alias{cost_path_cpp}
\title{Least Cost Path}
\usage{
cost_path_cpp(
  x,
  y,
  distance = "euclidean",
  diagonal = TRUE,
  weighted = TRUE,
  ignore_blocks = FALSE,
  bandwidth = 1
)
}
\arguments{
\item{x}{(required, numeric matrix) multivariate time series.}

\item{y}{(required, numeric matrix) multivariate time series
with the same number of columns as 'x'.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean".}

\item{diagonal}{(optional, logical). If TRUE, diagonals are included in the
computation of the cost matrix. Default: FALSE.}

\item{weighted}{(optional, logical). If TRUE, diagonal is set to TRUE, and
diagonal cost is weighted by y factor of 1.414214 (square root of 2). Default: FALSE.}

\item{ignore_blocks}{(optional, logical). If TRUE, blocks of consecutive path
coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.}

\item{bandwidth}{(required, numeric) Size of the Sakoe-Chiba band at
both sides of the diagonal used to constrain the least cost path. Expressed
as a fraction of the number of matrix rows and columns. Unrestricted by default.
Default: 1}
}
\value{
data frame
}
\description{
Least cost path between two time series \code{x} and \code{y}.
NA values must be removed from \code{x} and \code{y} before using this function.
If the selected distance function is "chi" or "cosine", pairs of zeros should
be either removed or replaced with pseudo-zeros (i.e. 0.00001).
}
\seealso{
Other Rcpp_cost_path: 
\code{\link{cost_path_diagonal_bandwidth_cpp}()},
\code{\link{cost_path_diagonal_cpp}()},
\code{\link{cost_path_orthogonal_bandwidth_cpp}()},
\code{\link{cost_path_orthogonal_cpp}()},
\code{\link{cost_path_slotting_cpp}()},
\code{\link{cost_path_sum_cpp}()},
\code{\link{cost_path_trim_cpp}()}
}
\concept{Rcpp_cost_path}
