% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{get_jackknife_values}
\alias{get_jackknife_values}
\title{Jackknife values}
\usage{
get_jackknife_values(grouping, stat_fun, data, ...)
}
\arguments{
\item{grouping}{A character string specifying the column in \code{data} that
contains the group names (i.e. a factorial variable, e.g., for the
differentiation of batches or formulations of a drug product).}

\item{stat_fun}{The name of the function calculating the statistic of
interest. The statistic function must return a single number.}

\item{data}{A data frame with the dissolution profile data in wide format
and a column for the distinction of the groups to be compared.}

\item{...}{Further arguments that may be passed down to the statistics
function.}
}
\value{
A list of the jackknife assessment with the following elements is
returned:
\item{theta.hat}{The original value of the statistic.}
\item{theta.jack}{The jackknife value of the statistic.}
\item{jack.se}{The jackknife standard error of the statistic.}
\item{jack.bias}{The bias of the statistic.}
\item{loo.values}{The leave-one-out values.}
\item{pseudo.values}{The pseudo values.}
}
\description{
The function \code{get_jackknife_values()} is required for generation of
vector \eqn{L} for the BCa confidence interval estimation by the
\code{boot.ci()} function from the \sQuote{\code{boot}} package.
}
\details{
For the calculation of BCa bootstrap confidence intervals empirical
influence values of the statistic of interest for the observed data are
required. If \eqn{L} is not provided to the \code{boot.ci()} function from
the \sQuote{\code{boot}} package, the values are calculated, if needed,
using the \code{empinf()} function (also from the \sQuote{\code{boot}}
package). Since the results returned by \code{empinf()} are not appropriate
in this case, the \eqn{L} values are determined using
\code{get_jackknife_values()}. The jackknife calculations are done by
calculating the leave-one-out estimates.
}
\references{
Chen, H. Bootstrap and Jackknife Calculations in R. 2004.
}
\seealso{
\code{\link{bootstrap_f2}}, \code{\link[boot]{boot}},
  \code{\link[boot]{boot.ci}}.
}
\keyword{internal}
