% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{ong_tidy}
\alias{ong_tidy}
\title{Ong et al. (2011) data: tidy format}
\format{
A tibble with 1100 rows and 9 variables.
}
\source{
\href{https://www.discovr.rocks/csv/ong_2011_tidy.csv}{www.discovr.rocks/csv/ong_2011_tidy.csv}
}
\usage{
ong_tidy
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
A study by Ong et al., (2011) examining the relationship between a person's narcissism and other people's ratings of their profile picture on Facebook.
The pictures were rated on each of four dimensions: coolness, glamour, fashionableness, and attractiveness. In addition, each person was measures on introversion/extroversion and narcissism.
These data are in tidy format. The data contains the following variables:
\itemize{
\item \strong{id}: a number identifying he participant
\item \strong{age}: participant's age in years
\item \strong{sex}: biological sex of the participant
\item \strong{status}: frequency of changing ones Facebook status per week
\item \strong{profile}: sum of profile picture ratings
\item \strong{extraversion}: score on the NEO Five-Factor Inventory (NEO-FFI) extraversion scale
\item \strong{narcissism}: score on the Narcissistic Personality Questionnaire for Children-Revised (NPQC-R)
\item \strong{rating_type}: the dimension along which profile pictures were rated (Attractiveness, Fashionable, Cool, Glamour)
\item \strong{rating}: rating of the profile picture from 1 (not attractive/cool/fashionable/glamourous) to 5 (very attractive/cool/fashionable/glamourous)
}
}
\references{
\itemize{
\item Ong, E. Y. L., Ang, R. P., Ho, J. C. M., Lim, J. C. Y., Goh, D. H., Lee, C. S., & Chua, A. Y. K. (2011). Narcissism, extraversion and adolescents' self-presentation on Facebook. \emph{Personality and Individual Differences}, 50, 180–185. \doi{10.1016/j.paid.2010.09.022}
}
}
\keyword{datasets}
