% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generator.R
\name{data_generator}
\alias{data_generator}
\title{Data Generator}
\usage{
data_generator(n, p, Delta = NULL, case = "sparse", seed = NULL)
}
\arguments{
\item{n}{The number of observations generated.}

\item{p}{The number of dimensions for the generated samples.}

\item{Delta}{Optional parameter - Provides the differential network that will be used to obtain the sample covariance matrices.}

\item{case}{Optional parameter - Selects under which case the covariance matrices are determined. Possible cases are: "sparse" - Sparse Case or "asymsparse"- Asymptotically Sparse Case. Defaults to "sparse".}

\item{seed}{Optional parameter - Allows a seed to be set for reproducibility.}
}
\value{
A list of various outputs, namely:
\itemize{
\item case - The case used.
\item seed_option - The seed provided.
\item X - The first multivariate normal sample.
\item Y - The second multivariate normal sample.
\item Sigma_X - The covariance matrix of X.
\item Sigma_Y - The covariance matrix of Y.
\item Omega_X - The precision matrix of X.
\item Omega_Y - The precision matrix of Y.
\item diff_Omega - The difference of precision matrices.
\item Delta - The target differential network.
}
}
\description{
This functions generates two \eqn{n} by \eqn{p} size samples of multivariate normal
data. In doing this it also determines and provides the relevant covariance
matrices.
}
\examples{
data <- data_generator(n = 100, p = 50, seed = 123)
data <- data_generator(n = 10, p = 50, case = "asymsparse")
}
