% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_coordinates.R
\name{viz_points}
\alias{viz_points}
\title{Build a Factor Map}
\usage{
viz_points(
  x,
  margin,
  axes,
  ...,
  active = TRUE,
  sup = TRUE,
  labels = FALSE,
  top = 10,
  highlight = NULL,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ann = graphics::par("ann"),
  frame.plot = TRUE,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "topleft")
)
}
\arguments{
\item{x}{A \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript
which the data will be returned: \code{1} indicates individuals/rows (the
default), \code{2} indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{...}{Further \link[graphics:par]{graphical parameters} (see details).}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
plotted?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
plotted?}

\item{labels}{A \code{\link{logical}} scalar: should labels be drawn?}

\item{top}{An \code{\link{integer}} specifying the number of labels to draw.
Only the labels of the \code{top} \eqn{n} observations contributing the most to
the factorial map will be drawn. If \code{NULL}, all labels are drawn.
Only used if \code{labels} is \code{TRUE}.}

\item{highlight}{A vector specifying the information to be highlighted.
If \code{NULL} (the default), no highlighting is applied. If a single \code{character}
string is passed, it must be one of "\code{observation}", "\code{mass}", "\code{sum}",
"\code{contribution}" or "\code{cos2}" (see \code{\link[=augment]{augment()}}). Any unambiguous substring
can be given.}

\item{xlim}{A length-two \code{\link{numeric}} vector giving the x limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{ylim}{A length-two \code{\link{numeric}} vector giving the y limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\description{
Build a Factor Map
}
\author{
N. Frerebeau
}
\keyword{internal}
