% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/jackknife.R
\docType{methods}
\name{jackknife}
\alias{jackknife}
\alias{jackknife-method}
\alias{jackknife,numeric-method}
\alias{summary,JackknifeVector-method}
\title{Jackknife Estimation}
\usage{
jackknife(object, ...)

\S4method{jackknife}{numeric}(object, do, ...)

\S4method{summary}{JackknifeVector}(object, ...)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector.}

\item{...}{Extra arguments passed to \code{do}.}

\item{do}{A \code{\link{function}} that takes \code{object} as an argument and returns a
single numeric value.}
}
\value{
\code{jackknife()} returns a \code{JackknifeVector} object (i.e. a \code{numeric}
vector of the \code{n} leave-one-out values of \code{do}).

\code{summary()} returns a named \code{numeric} vector with the following elements:
\describe{
\item{\code{mean}}{The jackknife estimate of mean of \code{do}.}
\item{\code{bias}}{The jackknife estimate of bias of \code{do}.}
\item{\code{error}}{he jackknife estimate of standard error of \code{do}.}
}
}
\description{
Jackknife Estimation
}
\examples{
## Jackknife
x <- rnorm(20)
jack <- jackknife(x, do = mean) # Sample mean
summary(jack)
}
\seealso{
Other resampling methods: 
\code{\link{bootstrap}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
