% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_digits.R
\name{extract_digits}
\alias{extract_digits}
\title{Extraction of First or Last Digits}
\usage{
extract_digits(x, check = 'first', include.zero = FALSE)
}
\arguments{
\item{x}{a numeric vector.}

\item{check}{location of the digits to extract. Can be \code{first}, \code{firsttwo}, or \code{last}.}

\item{include.zero}{logical. Whether to include the digit zero in the output.}
}
\value{
A vector of first (and optionally second) or last digits.
}
\description{
This function extracts the first (and optionally second) or last digits in a vector.
}
\examples{
set.seed(1)
x <- rnorm(100)

# Extract first digits (without zero)
extract_digits(x, check = 'first')

# Extract last digits (including zero)
extract_digits(x, check = 'last', include.zero = TRUE)

}
\author{
Koen Derks, \email{k.derks@nyenrode.nl}
}
\keyword{digits}
\keyword{extract}
