% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_diffudist.R
\name{plot_distance_matrix}
\alias{plot_distance_matrix}
\title{Plot distance matrix}
\usage{
plot_distance_matrix(
  DM,
  col_palette = viridis(n = 11),
  log_scale = FALSE,
  cex = 1,
  show_dendro = TRUE,
  title = ""
)
}
\arguments{
\item{DM}{a distance matrix}

\item{col_palette}{a colour palette, previously it was set to the `spectral`
palette of \link[RColorBrewer]{brewer.pal} but now it is, by default, to the
color-blind firendly \link[viridis]{viridis}.}

\item{log_scale}{logical. Default FALSE}

\item{cex}{numerical value by which text should be magnified (default font
size in \link[ggplot2]{theme} is 11)}

\item{show_dendro}{If the dendrogram resulting from \link[stats]{hclust} should
be shown. Default TRUE}

\item{title}{Title of the plot passed to \link[ggplot2]{labs}. No title by default.}
}
\value{
plot \link[ggplot2]{ggplot}
}
\description{
Plot a heatmap of the distance matrix using \link[ggplot2]{geom_tile}.
}
\keyword{distance}
\keyword{heatmap}
\keyword{matrix;}
\keyword{plot;}
