## ---- echo=FALSE---------------------------------------------------------
old.opt <- options(
  diffobj.disp.width=80, diffobj.pager="off", diffobj.format="html"
)

## ----echo=FALSE----------------------------------------------------------
A1 <- 1:10
B1 <- c(1:9, 11)
A2 <- 1:20
B2 <- c(20, 1:19)
A3 <- 1:20
B3 <- c(20:21, 1:19)

## ------------------------------------------------------------------------
all.equal(A1, B1)

## ------------------------------------------------------------------------
testthat::compare(A1, B1)

## ---- results="asis"-----------------------------------------------------
diffPrint(A1, B1)

## ------------------------------------------------------------------------
testthat::compare(A2, B2)

## ---- results="asis"-----------------------------------------------------
diffPrint(A2, B2)

## ------------------------------------------------------------------------
testthat::compare(A3, B3)

## ---- results="asis"-----------------------------------------------------
diffPrint(A3, B3)

## ---- results="asis"-----------------------------------------------------
A4 <- 1:1e4
B4 <- c(1e4 + 1, A4[-c(4:7, 9e3)])
diffPrint(A4, B4)

## ---- R.options=list(max.print=5)----------------------------------------
all.equal(iris, iris[-60,])

## ---- results="asis"-----------------------------------------------------
diffPrint(iris, iris[-60,])

## ---- R.options=list(max.print=5)----------------------------------------
all.equal(lm(hp ~ disp, mtcars), lm(hp ~ cyl, mtcars))

## ---- results="asis"-----------------------------------------------------
diffPrint(lm(hp ~ disp, mtcars), lm(hp ~ cyl, mtcars))

## ---- echo=FALSE---------------------------------------------------------
options(old.opt)

