% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_penalty.R
\name{penalty}
\alias{penalty}
\title{Amount of regularization/penalization}
\usage{
penalty(range = c(-10, 0), trans = log10_trans())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
A numeric parameter function representing the amount of penalties (e.g. L1,
L2, etc) in regularized models.
}
\details{
This parameter is used for regularized or penalized models such as
\code{parsnip::linear_reg()}, \code{parsnip::logistic_reg()}, and others.
}
\examples{
penalty()
}
