/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.metadata.DefaultMetadataDependenciesProvider;
import com.google.i18n.phonenumbers.prefixmapper.PrefixFileReader;
import java.util.Locale;

public class PhoneNumberToCarrierMapper {
    private static PhoneNumberToCarrierMapper instance = null;
    private final PrefixFileReader prefixFileReader;
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();

    PhoneNumberToCarrierMapper(String phonePrefixDataDirectory) {
        this.prefixFileReader = new PrefixFileReader(phonePrefixDataDirectory);
    }

    public static synchronized PhoneNumberToCarrierMapper getInstance() {
        if (instance == null) {
            instance = new PhoneNumberToCarrierMapper(DefaultMetadataDependenciesProvider.getInstance().getCarrierDataDirectory());
        }
        return instance;
    }

    public String getNameForValidNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        String langStr = languageCode.getLanguage();
        String scriptStr = "";
        String regionStr = languageCode.getCountry();
        return this.prefixFileReader.getDescriptionForNumber(number, langStr, scriptStr, regionStr);
    }

    public String getNameForNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        PhoneNumberUtil.PhoneNumberType numberType = this.phoneUtil.getNumberType(number);
        if (this.isMobile(numberType)) {
            return this.getNameForValidNumber(number, languageCode);
        }
        return "";
    }

    public String getSafeDisplayName(Phonenumber.PhoneNumber number, Locale languageCode) {
        if (this.phoneUtil.isMobileNumberPortableRegion(this.phoneUtil.getRegionCodeForNumber(number))) {
            return "";
        }
        return this.getNameForNumber(number, languageCode);
    }

    private boolean isMobile(PhoneNumberUtil.PhoneNumberType numberType) {
        return numberType == PhoneNumberUtil.PhoneNumberType.MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.PAGER;
    }
}

